<?php

namespace Modules\Goldiran\Traits;

use Modules\Goldiran\Models\Group;
use Modules\Goldiran\Models\Product;

trait Products {
    public static function getProducts(){

        $allProducts = Product::getWithStatus();
        $groups = Group::getWithStatus();
        $productsList = [];
        $groupList = [];
        $brandList = [];
        $brandList[0]='انتخاب برند';

        foreach (@$groups as $val){
            if($val->parent_id == 0){
                $brandList[$val->id] = $val->name;
            }else{
                $groupList[@$val->parent_id][@$val->id] = @$val->name;
            }
        }
        
        foreach (@$allProducts as $val) {
            $productsList[@$val->group_id][@$val->id] = @$val->name;
        }

        return
            [ 
                'brandList' => $brandList,
                'groupList' => $groupList,
                'productList' => $productsList,
            ];

    }
}