<?php

namespace Modules\Goldiran\Traits;

use SoapClient;

trait GS
{
    private $serviceUrl = 'http://wwz.goldirancs.ir/targanwebservice/service.asmx?WSDL';
    public function gsGetAllProduct()
    {
        try {
            $soap = new SoapClient($this->serviceUrl);
            $result = $soap->Get_AllProduct1(); //array('input' => $SettlementData)
        } catch (\SoapFault $e) {
            return null;
        }
        $allProducts = $result->Get_AllProduct1Result->Product;
        return $allProducts;
    }

    public function gsGetProductsFromGroup($id)
    {
        $allProducts = $this->gsGetAllProduct();
        $products = [];
        foreach ($allProducts as $value) {
            if ($value->productroupId == $id) {
                $products[$value->ProductCode] = $value->ProductFarsiName;
            }
        }
        return $products;
    }


    public function gsGetAllGroup()
    {
        $groups = $this->gsSoapGroups();
        $groupsArray = [];
        foreach ($groups[0]->productgroup as $value) {
            $groupsArray[(int)$value->ProductGroupId] = (string)$value->FaName;
        }
        return $groupsArray;
    }

    public function gsSoapGroups()
    {
        try {
            $soap = new SoapClient($this->serviceUrl);
            $result = $soap->Get_AllProductGroup(); //array('input' => $SettlementData)
        } catch (\SoapFault $e) {
            return null;
        }

        $sxe = new \SimpleXMLElement('<Get_AllProductGroup>' . $result->Get_AllProductGroupResult->any . '</Get_AllProductGroup>');
        $sxe->registerXPathNamespace('d', 'urn:schemas-microsoft-com:xml-diffgram-v1');
        $groups = $sxe->xpath('//DocumentElement');
        return $groups;
    }

    public function gsGetModelByProductCode($code)
    {
        try {
            $soap = new SoapClient($this->serviceUrl);
            $result = $soap->Get_Model_By_ProductCode1(['productcode' => $code]); //array('input' => $SettlementData)
        } catch (\SoapFault $e) {
            return null;
        }
        return $result->Get_Model_By_ProductCode1Result;
    }

    public function gsGetManual($model)
    {
        try {
            $soap = new SoapClient($this->serviceUrl);
            $result = $soap->Get_OwnerManual_By_Model(['model' => $model]);
        } catch (\SoapFault $e) {
            return null;
        }
        $sxe = new \SimpleXMLElement('<Get_AllProductGroup>' . $result->Get_OwnerManual_By_ModelResult->any . '</Get_AllProductGroup>');
        $sxe->registerXPathNamespace('d', 'urn:schemas-microsoft-com:xml-diffgram-v1');
        $result = $sxe->xpath('//DocumentElement');
        return empty($result) ? null : $result[0];
    }

    public function gsGetFollowRequest($type, $data)
    {
        try {
            $soap = new SoapClient($this->serviceUrl);
            $result = $soap->Get_ServiceByRMT(['type' => $type, 'value' => $data]);
        } catch (\SoapFault $e) {
            return null;
        }
        $sxe = new \SimpleXMLElement('<Get_AllProductGroup>' . $result->Get_ServiceByRMTResult->any . '</Get_AllProductGroup>');
        $sxe->registerXPathNamespace('d', 'urn:schemas-microsoft-com:xml-diffgram-v1');
        $result = $sxe->xpath('//DocumentElement');
        return empty($result) ? null : $result[0];
    }

    public function gsCheckWarranty($model, $serial)
    {
        try {
            $soap = new SoapClient($this->serviceUrl);
            $result = $soap->GET_WarrantyEndDate(['Serialno' => $serial, 'model' => $model]);
        } catch (\SoapFault $e) {
            return null;
        }
        return $result->GET_WarrantyEndDateResult;
    }

    public function gsGetAllProvince()
    {
        try {
            $soap = new SoapClient($this->serviceUrl);
            $result = $soap->Get_AllProvince();
        } catch (\SoapFault $e) {
            return null;
        }
        $sxe = new \SimpleXMLElement('<Get_AllProductGroup>' . $result->Get_AllProvinceResult->any . '</Get_AllProductGroup>');
        $sxe->registerXPathNamespace('d', 'urn:schemas-microsoft-com:xml-diffgram-v1');
        $result = $sxe->xpath('//DocumentElement');
        return empty($result) ? null : $result[0];
    }

    public function gsGetCity()
    {
        try {
            $soap = new SoapClient($this->serviceUrl);
            $result = $soap->Get_AllCity();
        } catch (\SoapFault $e) {
            return null;
        }
        $sxe = new \SimpleXMLElement('<Get_AllProductGroup>' . $result->Get_AllCityResult->any . '</Get_AllProductGroup>');
        $sxe->registerXPathNamespace('d', 'urn:schemas-microsoft-com:xml-diffgram-v1');
        $result = $sxe->xpath('//DocumentElement');
        return empty($result) ? null : $result[0];
    }

    public function gsGetAgents($provinceid, $cityid)
    {
        try {
            $soap = new SoapClient($this->serviceUrl);
            $result = $soap->Get_Agents_By_PCT(['provinceid' => $provinceid, 'cityid' => $cityid]);
        } catch (\SoapFault $e) {
            return null;
        }
        $sxe = new \SimpleXMLElement('<Get_AllProductGroup>' . $result->Get_Agents_By_PCTResult->any . '</Get_AllProductGroup>');
        $sxe->registerXPathNamespace('d', 'urn:schemas-microsoft-com:xml-diffgram-v1');
        $result = $sxe->xpath('//DocumentElement');
        return empty($result) ? null : $result;
    }

    public function gsGetRegionByCity($id)
    {
        try {
            $soap = new SoapClient($this->serviceUrl);
            $result = $soap->Get_AllRegionByCity(['cityId' => $id]);
        } catch (\SoapFault $e) {
            return null;
        }
        $sxe = new \SimpleXMLElement('<Get_AllProductGroup>' . $result->Get_AllRegionByCityResult->any . '</Get_AllProductGroup>');
        $sxe->registerXPathNamespace('d', 'urn:schemas-microsoft-com:xml-diffgram-v1');
        $result = $sxe->xpath('//DocumentElement');
        return empty($result) ? null : $result[0];
    }

    public function gsGetParishByRegion($id)
    {
        try {
            $soap = new SoapClient($this->serviceUrl);
            $result = $soap->Get_AllParishByRegion(['regionId' => $id]);
        } catch (\SoapFault $e) {
            return null;
        }
        $sxe = new \SimpleXMLElement('<Get_AllProductGroup>' . $result->Get_AllParishByRegionResult->any . '</Get_AllProductGroup>');
        $sxe->registerXPathNamespace('d', 'urn:schemas-microsoft-com:xml-diffgram-v1');
        $result = $sxe->xpath('//DocumentElement');
        return empty($result) ? null : $result[0];
    }

    public function gsInsertService($input)
    {
        if (in_array($input['mobile'], ['09147469731', '09025286256'])) {
            return null;
        }
        if (!array_key_exists('promiseDate', $input)) {
            $input['promiseDate'] = \Carbon\Carbon::now()->format('Y-m-d\Th:i:s');
        }

        for ($i = 0; $i < 5; $i++) {
            try {
                $soap = new SoapClient($this->serviceUrl);
                $result = $soap->Insert_Service($input);
                if ($result) break;
            } catch (\SoapFault $e) {
                if ($i == 4)
                    return null;
                else
                    sleep(1);
            }
        }
        return $result->Insert_ServiceResult;
    }

    public function gsInsertOnLineSaleOrder($input)
    {
        try {
            $soap = new SoapClient($this->serviceUrl);
            $result = $soap->Insert_OnLineSaleOrder($input);
        } catch (\SoapFault $e) {
            return null;
        }
        return $result->Insert_OnLineSaleOrderResult;
    }

    public function gsPartBalance($part_no)
    {
        try {
            // if (config('app.env', null) == 'local') {
            //     $exportValue = \Storage::get("gs/gsPartBalance/{$part_no}.txt");
            //     eval('$result = ' . $exportValue . ';');
            // } else {
            $soap = new SoapClient($this->serviceUrl);
            $result = $soap->PartBalance(['partNo' => $part_no]);
            // }
        } catch (\SoapFault $e) {
            return $e;
        }

        $sxe = new \SimpleXMLElement('<PartBalanceResponse>' . $result->PartBalanceResult->any . '</PartBalanceResponse>');
        $sxe->registerXPathNamespace('d', 'urn:schemas-microsoft-com:xml-diffgram-v1');
        $result = $sxe->xpath('//DocumentElement');
        if (empty($result))
            return 'this is bad result';
        else {
            $result[0]->partInfo->customerPrice = ceil($result[0]->partInfo->customerPrice * 1.09 /1000) * 1000;
            return  $result[0];
        }
    }

    public function gsProductByMobile($mobile)
    {
        try {
            $soap = new SoapClient($this->serviceUrl);
            $result = $soap->GET_ProductsByMobile(['mobile' => $mobile]);
        } catch (\SoapFault $e) {
            return null;
        }

        $sxe = new \SimpleXMLElement('<GET_ProductsByMobileResult>' . $result->GET_ProductsByMobileResult->any . '</GET_ProductsByMobileResult>');
        $sxe->registerXPathNamespace('d', 'urn:schemas-microsoft-com:xml-diffgram-v1');
        $result = $sxe->xpath('//DocumentElement');
        return empty($result) ? null : $result[0];
    }

    public function gsServiceByMobile($mobile)
    {
        try {
            $soap = new SoapClient($this->serviceUrl);
            $result = $soap->GET_ServicesByMobile(['mobile' => $mobile]);
        } catch (\SoapFault $e) {
            return null;
        }

        $sxe = new \SimpleXMLElement('<GET_ServicesByMobileResult>' . $result->GET_ServicesByMobileResult->any . '</GET_ServicesByMobileResult>');
        $sxe->registerXPathNamespace('d', 'urn:schemas-microsoft-com:xml-diffgram-v1');
        $result = $sxe->xpath('//DocumentElement');
        return empty($result) ? null : $result[0];
    }

    public function gsModelsByPartNumber($partNumber)
    {
        try {
            $soap = new SoapClient($this->serviceUrl);
            $result = $soap->GET_ModelsWithPart(['partNo' => $partNumber]);
        } catch (\SoapFault $e) {
            return null;
        }

        $sxe = new \SimpleXMLElement('<GET_ModelsWithPartResult>' . $result->GET_ModelsWithPartResult->any . '</GET_ModelsWithPartResult>');
        $sxe->registerXPathNamespace('d', 'urn:schemas-microsoft-com:xml-diffgram-v1');
        $result = $sxe->xpath('//DocumentElement');
        return empty($result) ? null : $result[0];
    }

    public function gsGETNpsServices($code)
    {
        try {
            // if (config('app.env', null) == 'local') {
            //     $exportValue = \Storage::get("gs/gsInsertHCRegister/{$code}.txt");
            //     eval('$result = ' . $exportValue . ';');
            // } else {
            $soap = new SoapClient($this->serviceUrl);
            $result = $soap->GET_NpsServices(['code' => $code]);
            // }

        } catch (\SoapFault $e) {
            return null;
        }

        $sxe = new \SimpleXMLElement('<GET_NpsServicesResult>' . $result->GET_NpsServicesResult->any . '</GET_NpsServicesResult>');
        $sxe->registerXPathNamespace('d', 'urn:schemas-microsoft-com:xml-diffgram-v1');
        $result = $sxe->xpath('//DocumentElement');
        return empty($result) ? null : $result[0];
    }

    public function gsInsertRegisterNps($input)
    {
        try {
            if (config('app.env', null) == 'local') {
                $name = is_array($input) ? $input['serviceNo'] : $input;
                $exportValue = \Storage::get("gs/gsInsertRegisterNps/{$name}.txt");
                eval('$result = ' . $exportValue . ';');
            } else {
                $soap = new SoapClient($this->serviceUrl);
                $result = $soap->RegisterNps($input);
            }
        } catch (\SoapFault $e) {
            return null;
        }
        return $result->RegisterNpsResult;
    }

    public function gsInsertHCRegister($input)
    {
        try {
            if (config('app.env', null) == 'local') {
                $name = is_array($input) ? $input['serviceNo'] : $input;
                $exportValue = \Storage::get("gs/gsInsertHCRegister/{$name}.txt");
                eval('$result = ' . $exportValue . ';');
            } else {
                $soap = new SoapClient($this->serviceUrl);
                $result = $soap->Insert_HcServiceRegistration($input);
            }
            // $exportValue = var_export($result, true);
            // $name = is_array($input) ? $input['serviceNo'] : $input;
            // \Storage::put("gs/gsInsertHCRegister/{$name}.txt", $exportValue);
        } catch (\SoapFault $e) {

            return null;
        }
        return $result->Insert_HcServiceRegistrationResult;
    }

    public function gsGETTechnicianInfo($code)
    {
        try {
            if (config('app.env', null) == 'local') {
                $exportValue = \Storage::get("gs/gsGETTechnicianInfo/{$code}.txt");
                eval('$result = ' . $exportValue . ';');
            } else {
                $soap = new SoapClient($this->serviceUrl);
                $result = $soap->GET_TechnicianInfo(['technicianCode' => $code]);
            }
            // $exportValue = var_export($result, true);
            // \Storage::put("gs/gsGETTechnicianInfo/{$code}.txt", $exportValue);
        } catch (\SoapFault $e) {
            return null;
        }

        $sxe = new \SimpleXMLElement('<GET_TechnicianInfoResult>' . $result->GET_TechnicianInfoResult->any . '</GET_TechnicianInfoResult>');
        $sxe->registerXPathNamespace('d', 'urn:schemas-microsoft-com:xml-diffgram-v1');
        $result = $sxe->xpath('//DocumentElement');
        return empty($result) ? null : $result[0]->technicianInfo;
    }

    public function gsGetCustomerInfoByMobile($mobile)
    {
        try {
            $soap = new SoapClient($this->serviceUrl);
            $result = $soap->GET_CustomerInfoByMobile(['mobile' => $mobile]);
        } catch (\SoapFault $e) {
            return null;
        }

        $sxe = new \SimpleXMLElement('<GET_CustomerInfoByMobileResult>' . $result->GET_CustomerInfoByMobileResult->any . '</GET_CustomerInfoByMobileResult>');
        $sxe->registerXPathNamespace('d', 'urn:schemas-microsoft-com:xml-diffgram-v1');
        $result = $sxe->xpath('//DocumentElement');
        return empty($result) ? null : (array)$result[0]->parts;
    }

    public function gsGetHcServiceRegistration($code)
    {
        try {
            if (config('app.env', null) == 'local') {
                $exportValue = \Storage::get("gs/gsGetHcServiceRegistration/{$code}.txt");
                eval('$result = ' . $exportValue . ';');
            } else {
                $soap = new SoapClient($this->serviceUrl);
                $result = $soap->GET_GEtHcServiceRegistration(['mobile' => $code]);
            }
        } catch (\SoapFault $e) {
            return null;
        }

        $sxe = new \SimpleXMLElement('<GET_GEtHcServiceRegistrationResult>' . $result->GET_GEtHcServiceRegistrationResult->any . '</GET_GEtHcServiceRegistrationResult>');
        $sxe->registerXPathNamespace('d', 'urn:schemas-microsoft-com:xml-diffgram-v1');
        $result = $sxe->xpath('//DocumentElement');
        return empty($result) ? null : $result[0];
    }

    public function gsGetReguarantProducts($token)
    {
        try {
            $soap = new SoapClient($this->serviceUrl);
            $result = $soap->getReguarantProducts(['token' => $token]);
        } catch (\SoapFault $e) {
            return null;
        }
        
        return $result->getReguarantProductsResult;
    }
    public function gsGetReguarantPrices($mobile,$productList)
    {
        try {
            $soap = new SoapClient($this->serviceUrl);
            $result = $soap->getReguarantPrices(['mobileNo' => $mobile, 'productList' => $productList]);
        } catch (\SoapFault $e) {
            return null;
        }
       
        return $result->getReguarantPricesResult;
    }

    public function gsRegisterReguarant($input)
    {
        try {
            $soap = new SoapClient($this->serviceUrl);
            $result = $soap->registerReguarant($input);
        } catch (\SoapFault $e) {
            return null;
        }
        return $result->registerReguarantResult;
    }
}
