@section('content')
    <div class="col-md-12">
        <div class="table-responsive">
            <table class="table table-bordered table-striped">
                <tr>
                    <td>@lang('language.title'):</td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                                <i class="fa fa-user"></i>
                                {!! Form::text('frm[name]', @$list['name'], array('class' => 'form-control'))  !!}
                            </div>
                        </div>
                    </td>
                </tr>

                <tr>
                    <td>@t('parent'):</td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                                <i class="fa fa-user"></i>
                                {!! Form::select('frm[parent_id]', $parentList, @$list->parent_id, ['class' => 'form-control sub-category w-100','data-advancedselect' => 'select2','style' => 'width:100%'])  !!}
                            </div>
                        </div>
                    </td>
                </tr>

                <tr>
                    <td>@lang('language.description'):</td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                                <i class="fa fa-user"></i>
                                {!! Form::text('frm[description]', @$list['description'], array('class' => 'form-control'))  !!}
                            </div>
                        </div>
                    </td>
                </tr>

                <tr>
                    <td>@lang('language.display rank'):</td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                                <i class="fa fa-user"></i>
                                {!! Form::text('frm[xrank]', @$list['xrank'], array('class' => 'form-control'))  !!}
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <table class="table table-striped">
                            <tr>
                                <th>@lang('language.picture')</th>
                                <th>@t('menu picture')</th>
                            </tr>
                            <tr>
                                <td>
                                    @include('admin.partial.fileInput', ['exist' => @$imgExist, 'src' => '/pic/category/' . @$list['xcategoryid'] . 'w200h150c1/' . str_random() . '.png?nocache=1', 'action' => 'deleteImg',  'id' => @$list['xcategoryid']])
                                </td>
                                <td>
                                    @include('admin.partial.fileInput', ['exist' => @$menuExist, 'src' => '/pic/category.menu/' . @$list['xcategoryid'] . 'w200h150c1/' . str_random() . '.png?nocache=1', 'action' => 'deleteImg',  'id' => @$list['xcategoryid'], 'name'=>'category/menu', 'type' => 'menu'])
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>

            {{-- Warehouse Section List --}}
            <div class="col-md-12 col-xs-12 table-responsive ">
                <h4 class="seperator-title">@t('sub category'): </h4>
                <table class="table table-bordered table-striped">
                     <tr>
                        @if (@$subList)
                            @foreach (@$subList as $key => $sub)
                                @var('j',$key+1)

                                @var('namePrefix','subList[row'.$j.']')
                                @include('backend.templete.imageBox',[
                                    'namePrefix' => $namePrefix,
                                    'list' => $sub,
                                    'fields' => [
                                        ['name'=>'id', 'title'=>'id', 'type'=>'hidden', 'class'=>'reset'],
                                        ['name'=>'name', 'title'=>'title', 'type'=>'text'],
                                        ['name'=>'description', 'title'=>'description', 'type'=>'text'],
                                        ['name'=>'xrank', 'title'=>'rank', 'type'=>'number'],
                                    ]
                                ])

                            @endforeach
                        @endif
                        <script>
                            App.normalizeRows('sub-list');
                        </script>
                        <div class="clearfix"></div>
                    </tr>
                </table>
            </div>
        </div>
    </div>
@stop