<?php namespace Modules\Goldiran\Models;

use App;
use App\Models\Model;
use DB;
use Modules\Home\Models\Tag;


class SurveyVoc extends Model {
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'survey_voc';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;
    public $lang = false;

    protected $guarded = ['id'];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'answer_id' => 'int',
        'order' => 'int',
        'otherid' => 'int',
    ];

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        $res = DB::table($instance->table)
            ->leftJoin('survey_answer','answer_id','=','survey_answer.otherid')
            ->select(["{$instance->table}.*", "{$instance->table}.{$instance->primaryKey} AS xid", "survey_answer.name AS answer_name"]);

        return $res;
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();

        if ($id) {
            $res = $instance->destroy($id);
            parent::deleteFile($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }

        return $res;
    }

}