<?php namespace Modules\Goldiran\Models;

use App;
use App\Models\Model;
use DB;
use Modules\Home\Models\Tag;


class SurveyQuestion extends Model {
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'survey_question';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;
    public $lang = false;

    protected $guarded = ['id'];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'service_type' => 'int',
        'order' => 'int',
        'type' => 'int',
        'otherid' => 'int',
    ];

    /**
     * Get the category that owns the book.
     */
    public function answers() {
        return $this->hasMany(SurveyAnswer::class, 'question_id','otherid');
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        $res = DB::table($instance->table)
            ->leftJoin('survey_config','survey_config.id','=',$instance->table.'.type')
            ->groupBy($instance->table. '.' . $instance->primaryKey)
            ->select(["{$instance->table}.*", "{$instance->table}.{$instance->primaryKey} AS xid", "survey_config.name AS type_name"]);

        return $res;
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();

        if ($id) {
            $res = $instance->destroy($id);
            parent::deleteFile($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }

        return $res;
    }

}