<?php namespace Modules\Goldiran\Models;

use App\Models\Model;
use Modules\Shop\Models\Product;
use DB;

class ProductModel extends Model {
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'goldiran_product_model';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'product_id';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    protected $guarded = [];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'xrank' => 'int',
        'product_id' => 'int',
    ];

    /**
     * Get the category that owns the sub category.
     */
    public function product() {
        return $this->belongsTo(Product::class, 'product_id');
    }


    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        $res = DB::table($instance->table)
            ->select(['*', "{$instance->primaryKey} AS xid"]);

        return $res;
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();

        $cond = (int) $id ? "{$instance->primaryKey} = '$id'" : $id;

        $res = $instance->newQuery()->whereRaw($cond)->delete();
        return $res;
    }
}