<?php namespace Modules\Goldiran\Models;

use App;
use App\Models\Model;
use DB;
use Modules\Home\Models\Tag;


class Product extends Model {
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'goldiran_product';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    protected $guarded = ['id'];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'group_id' => 'int',
        'xrank' => 'int',
    ];

    /**
     * Get the category that owns the book.
     */
    public function group() {
        return $this->belongsTo(Group::class, 'group_id');
    }

    public function tags() {
        return $this->morphToMany(Tag::class, 'taggable', 'xxtaggables', 'taggable_id', 'tag_id');
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        $res = DB::table($instance->table)
            ->select(['*', "{$instance->primaryKey} AS xid"]);

        return $res;
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();

        if ($id) {
            $res = $instance->destroy($id);
            parent::deleteFile($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }

        return $res;
    }

}