<?php
namespace Modules\Goldiran\Http\Controllers\Index;

use App\Http\Controllers\IndexController;
use Modules\Goldiran\Traits\GS;
use Modules\Goldiran\Models\Group;
use Input;
use Modules\Goldiran\Entities\Survey;
use Modules\Goldiran\Models\Product;
use Modules\Home\Models\Service;
use Modules\Goldiran\Models\SurveyQuestion;
use Modules\Goldiran\Models\SurveyVoc;
use Session;
use Image;
use Request;

class TechnicianController extends IndexController {
    use GS;
    /*
    |--------------------------------------------------------------------------
    | Home Controller
    |--------------------------------------------------------------------------
    |
    | This controller renders your application's "dashboard" for users that
    | are authenticated. Of course, you are free to change or remove the
    | controller as you wish. It is just here to get your app started!
    |
     */
    protected $layout = 'account::index.auth.layout';
    /**
     * Show the application dashboard to the user.
     *
     * @return Response
     */
    public function index($code) {
        if(!$code){
            return self::setError('در حال حاضر تکنسین فعالی برای شما موجود نمی باشد.',0,'home');
          
        }

        $surveys = $this->gsGetHcServiceRegistration($code);
        
        if(!$surveys){
            return self::setError('در حال حاضر تکنسین فعالی برای شما موجود نمی باشد.',0,'home');
          
        }
        $services = Service::pluck('name','other_id');
        $mapSurvey = [];
        $serviceNumbers = [];
        $pictures = [];
        $hasPeriodicService = false;
        $isBeforeRegister = false;
        $serviceType = 3;
        foreach($surveys as $value){
            $value = (array)$value;
            if($value['ServiceTypeID'] == 4) $hasPeriodicService = true;
            if($value['SurveyStatus'] != 0) $isBeforeRegister = true;

            $mapSurvey[$value['technicianCode']]['items'][] = $value;
            if(!@$mapSurvey[$value['technicianCode']]['name']){
                $mapSurvey[$value['technicianCode']]['name'] = $value['firstName'].' '.$value['lastName'];
                $mapSurvey[$value['technicianCode']]['code'] = $value['technicianCode'];
                $mapSurvey[$value['technicianCode']]['Mobile'] = $value['Mobile'];
                $pictures[$value['technicianCode']] = $value['picture'];
            }
            
            $mapSurvey[$value['technicianCode']]['service'] = @$mapSurvey[$value['technicianCode']]['service'] . '<br><span>'. $services[@$value['ServiceTypeID']??3] .' ' . $value['ProductFarsiName'] . '</span>';
            $serviceNumbers[] = $value['ServiceNo'];
            $serviceType = $value['ServiceTypeID'];
        }
        
        self::imageCrop($pictures);
        $questions = Survey::getQuestions(2,$serviceType,null);
        $this->layout->content = view('goldiran::index.technician.survey',array_merge($questions,
            [   
                'services' => $services,
                'technicians' => $mapSurvey,
                'serviceNo' => implode(',', $serviceNumbers),
                'customerCode' => $code,//$mapSurvey[$value['technicianCode']]['Mobile'], 
                'hasPeriodicService' => $hasPeriodicService,    
                'isBeforeRegister' => $isBeforeRegister,   
            ]));
    }

    public function imageCrop($pictures){
        foreach($pictures as $key => $picture){
            try{
                $img = Image::make($picture);
            }catch(\Throwable $th){
                continue;
            }
            
            $img->widen(300)->crop(230, 230, 35, 0)->sharpen(5)->contrast(20);
            $img->save(config('upload.GSTechnecian').'/'.$key);
        }
    }
    

    public function register(){
        $serviceNo =explode(',', Input::get('serviceNo'));
        $customerCode = Input::get('customerCode');
        $voc = Input::get('voc');
        $answers = Input::get('answers');
        $comment = Input::get('comment');
        
        if (!current($answers)){
            self::setError('اطلاعات ورودی نادرست می باشد.',0,'surveyList');
            return;
        }
        
        $questionId = array_keys($answers)[0];
        $answerId = $answers[$questionId];
        $result = [];

        foreach($serviceNo as $value){
            $result[] = Survey::registerTechnician($questionId, $answerId, $value, $customerCode,$comment);
        }


        if(!$result){
            $message = 'ثبت نظر شما با مشکل روبرو شد. لطفا دوباره تلاش نمائید.';
            $status = 0;
        }else{
            $message = 'نظر شما با موفقیت ثبت شد.';
            $status = 1;
        }
        return self::setError($message,$status,'surveyList');

    }

    private function setError($message,$status,$button){
        
        $result = [
            'message' => $message,
            'status' => $status,
            
        ];
        
        if(Request::ajax())
            return response()->json($result);
        else
            $this->layout->content = view('goldiran::index.survey.messageView', $result);
    }

}
