<?php
namespace Modules\Goldiran\Http\Controllers\Index;

use App\Http\Controllers\IndexController;
use Modules\Goldiran\Traits\GS;
use Modules\Goldiran\Models\Group;
use Input;
use Modules\Goldiran\Entities\Survey;
use Modules\Goldiran\Models\Product;
use Modules\Home\Models\Service;

use Session;
use Request;

class SurveyController extends IndexController {
    use GS;
    /*
    |--------------------------------------------------------------------------
    | Home Controller
    |--------------------------------------------------------------------------
    |
    | This controller renders your application's "dashboard" for users that
    | are authenticated. Of course, you are free to change or remove the
    | controller as you wish. It is just here to get your app started!
    |
     */
    protected $layout = 'account::index.auth.layout';
    /**
     * Show the application dashboard to the user.
     *
     * @return Response
     */
    public function index($code,$message = null) {
        
        if(!$code){
            return self::setError('در حال حاضر نظرسنجی فعالی برای شما موجود نمی باشد.',0,'home');
        }
        
        $surveys = $this->gsGETNpsServices($code);
        
        if(!$surveys){
            if($message)
                return redirect('/landing/survey/success-offer')->with('alert', ['label' => 'success', 'title' => 'نظر شما با موفقیت در سامانه ثبت شد.']);
            else
                return self::setError('در حال حاضر نظرسنجی فعالی برای شما موجود نمی باشد.',0,'home');
        }
        $products = Product::all();
        $services = Service::all();
        Session::put('survey_code',$code);
        $this->layout->content = view('goldiran::index.survey.surveyList',
            [   
                'surveys' => $surveys,
                'products' => $products,
                'services' => $services,
                'message' => $message
            ]);
    }

    public function getQuestion(){
        $productCode = Input::get('productCode');
        $isLogestic = Input::get('isLogestic');
        $repairCode = Input::get('repairCode');
        $serviceType = Input::get('serviceType') ?? 3;
        $customerCode = Input::get('customerCode');
        $serviceNo = Input::get('serviceNo');

        $questions = Survey::getQuestions(1,$serviceType,$productCode);
        $this->layout->content = view('goldiran::index.survey.survey',array_merge($questions,
            [   
                'serviceNo' => $serviceNo,
                'customerCode' => $customerCode,
            ]));
    }
    
    public function register(){
        $serviceNo = Input::get('serviceNo');
        $customerCode = Input::get('customerCode');
        $voc = Input::get('voc');
        $answers = Input::get('answers');
        $comment = Input::get('comment');
        
        if (!$answers || !$voc){
            return self::setError('اطلاعات ورودی نادرست می باشد.',0,'surveyList');
        }
        
        $result = Survey::register($answers, $voc, $serviceNo, $customerCode,$comment);
        
        if(!$result){
            $message = 'ثبت نظرسنجی با مشکل روبرو شد. لطفا دوباره تلاش نمائید.';
            $status = 0;
        }else{
            return self::setSuccess('نظر شما با موفقیت ثبت شد.');
        }
        return self::setError($message,$status,'surveyList');
    }

    private function setError($message,$status,$button){
        $button = ($button == 'surveyList') ? ['text' => 'بازگشت به صفحه نظرسنجی' , 'link' => '/survey/'.Session::get('survey_code')] : ['text' => 'بازگشت به صفحه اصلی' , 'link' => '/'];
        $result = [
            'message' => $message,
            'status' => $status,
            'button' => $button
        ];
        
        if(Request::ajax())
            return response()->json($result);
        else
            $this->layout->content = view('goldiran::index.survey.messageView', array_merge($result,['notView' => false]));            
    }

    private function setSuccess($message){
        $code = Session::get('survey_code');
        return self::index($code,$message);
    }

}
