<?php

namespace Modules\Goldiran\Http\Controllers\Index;

use App\Http\Controllers\IndexController;
use Modules\Blog\Models\Article;
use Modules\Goldiran\Models\Group;
use Modules\Goldiran\Models\Product;
use Modules\Goldiran\Traits\GS;
use Modules\Home\Traits\Location;
use Input;
use Modules\Goldiran\Models\ProductDriver;
use Validator;



class RequestController extends IndexController
{
    use GS, Location;
    /*
    |--------------------------------------------------------------------------
    | Home Controller
    |--------------------------------------------------------------------------
    |
    | This controller renders your application's "dashboard" for users that
    | are authenticated. Of course, you are free to change or remove the
    | controller as you wish. It is just here to get your app started!
    |
     */

    /**
     * Show the application dashboard to the user.
     *
     * @return Response
     */

    
    public function index($id, $title = '') {
        
        $lastArticles = Article::orderBy('xrank', 'desc')
            ->orderBy('created_at', 'desc')
            ->take(7)
            ->where('xstatus',1)
            ->where('xarticle_top',1)
            ->getWithLocale();

        $allProducts = Product::getWithStatus();
        $groups = Group::getWithStatus();
        $productsList = [];
        $groupList = [];
        $brandList = [0 => 'انتخاب برند محصول'];
        $fullBrandList = [];
        $fullGroupList = [];

        foreach (@$groups as $val){
            if($val->parent_id == 0){
                $brandList[$val->id] = $val->name;
                $fullBrandList[] = $val;
            }else{
                $groupList[@$val->parent_id][@$val->id] = @$val->name;
                $fullGroupList[] = $val;
            }
        }
        
        foreach (@$allProducts as $val) {
            $productsList[@$val->group_id][@$val->id] = @$val->name;
        }

        $location = self::getZones();
        
        $this->layout->content = view('goldiran::index.request',
            array_merge([   
                'lastArticles' => $lastArticles,
                'productList' => $productsList,
                'groupList' => $groupList,
                'brandList' => $brandList,
                'fullProductList' => $allProducts,
                'fullBrandList' => $fullBrandList,
                'fullGroupList' => $fullGroupList,
                'user' => \Auth::user()
            ],$location));
    }

    public function getLocation(){
        $location = self::getPriorityZone();
        return response()->json($location);
    }

    public function getCity(){
        $id = Input::get('id');
        $location = self::getCityZone($id);
        return response()->json($location);
    }

    public function getRegion(){
        $id = Input::get('id');
        $location = self::getRegionZone($id);
        return response()->json($location);
    }

    public function getParish(){
        $id = Input::get('id');
        $location = self::getParishZone($id);
        return response()->json($location);
    }

    public function content()
    {
        $allProducts = Product::getWithStatus();
        $groups = Group::orderBy('parent_id','asc')->getWithStatus();
        $products = [];
        $productsList = [];
        foreach (@$allProducts as $val) {
            $productsList[@$val->group_id][@$val->id] = [
                'id' => $val->id,
                'title' => $val->name,
                'icon' => '/goldiran/r/products/' . explode(',',trim($val->code))[0] .'.png'
            ];
        }

        foreach (@$groups as $val){
            if($val->parent_id == 0){
                $products[$val->id] = [
                    'id' => $val->id,
                    'title' => $val->name,
                    'icon' => '/goldiran/r/brands/'. $val->id .'.png',
                    'items' => []
                ];
            }else{
                $products[$val->parent_id]['items'][$val->id] = [
                    'id' => $val->id,
                    'title' => $val->name,
                    'icon' => '/goldiran/r/groups/'. $val->id .'.png',
                    'items' => isset($productsList[$val->id]) ? $productsList[$val->id] : []
                ];
            }
        }
        
        $result = [
            'loyalty' => [
                'build_number' => true,
                'enabled' => true,
                'referral_link' => "https'=>//cs.goldiran.ir/clup/?s=s&utm_source=mainpage&utm_medium=point",
                'selectable' => true,
                'track_id' => "ChoicePoints",
                'url_scheme' => true,
            ],
            'promotions' => [
                'enabled' => true,
                'items' => [
                    [
                        'icon' => "/goldiran/services/33.png",
                        'id' => 1,
                        'title' => "سرویس دوره ای",
                        'description' => 'هر 6 ماه یکبار ما با شمائیم',
                        'background_color' => '#d7172f',//'#11bffe',
                        'background_border_color' => '#c7172d',//'#1cb4e6',
                        'track_id' => "ChoiceCab",
                        'type' => 1,
                    ],
                    [
                        'icon' => "/goldiran/services/11.png",
                        'id' => 2,
                        'title' => "تمدید دوره ای",
                        'description' => 'خیال خود را آسوده کنید',
                        'background_color' => '#d7172f',//'#f9cd64',
                        'background_border_color' => '#c7172d',//'#f1c876',
                        'track_id' => "ChoiceCab",
                        'type' => 1,
                    ],
                    [
                        'icon' => "/goldiran/services/22.png",
                        'id' => 3,
                        'title' => "نصب و راه اندازی",
                        'description' => 'خیال خود را آسوده کنید',
                        'background_color' => '#d7172f',//'#3ab775',
                        'background_border_color' => '#c7172d',//'#3ba574',
                        'track_id' => "ChoiceCab",
                        'type' => 1,
                    ],
                    [
                        'icon' => "/goldiran/services/44.png",
                        'id' => 4,
                        'title' => "تعمیر",
                        'description' => 'خیال خود را آسوده کنید',
                        'background_color' => '#d7172f',//'#ff7513',
                        'background_border_color' => '#c7172d',//'#df5d0f',
                        'track_id' => "ChoiceCab",
                        'type' => 1,
                    ],
                ]
            ],
            'brands' => $products,
            'sections' => [
                'section_size' =>  2,
                'title' => "در خانه بمانید",
                'type' => "banner",
                'items' => [
                    [
                        'action_title' => "اطلاعات بیشتر",
                        'description' => "سرویس دوره ای ویژه",
                        'icon_url' => "https://cs.goldiran.ir/Redesign-Icons/market.png",
                        'id' => 13,
                        'image_url' => "/goldiran/ad/Wallet-Pr.jpg",
                        'referral_link' => "https://cs.goldiran.ir/request",
                        'track_id' => "ChoiceBanner-StayHomeMarket",
                        'type' => 4
                    ],
                    [
                        'action_title' => "اطلاعات بیشتر",
                        'description' => "تمدید دوره ای ویژه",
                        'icon_url' => "https://cs.goldiran.ir/Redesign-Icons/market.png",
                        'id' => 13,
                        'image_url' => "/goldiran/ad/SnappVsCorona-AppBanner-15.jpg",
                        'referral_link' => "https://cs.goldiran.ir/request",
                        'track_id' => "ChoiceBanner-StayHomeMarket",
                        'type' => 4
                    ],
                    [
                        'action_title' => "اطلاعات بیشتر",
                        'description' => "تمدید دوره ای ویژه",
                        'icon_url' => "https://cs.goldiran.ir/Redesign-Icons/market.png",
                        'id' => 13,
                        'image_url' => "/goldiran/ad/Medium-FA-Doctor.jpg",
                        'referral_link' => "https://cs.goldiran.ir/request",
                        'track_id' => "ChoiceBanner-StayHomeMarket",
                        'type' => 4
                    ],
                    [
                        'action_title' => "اطلاعات بیشتر",
                        'description' => "تمدید دوره ای ویژه",
                        'icon_url' => "https://cs.goldiran.ir/Redesign-Icons/market.png",
                        'id' => 13,
                        'image_url' => "/goldiran/ad/Medium-FA-food.jpg",
                        'referral_link' => "https://cs.goldiran.ir/request",
                        'track_id' => "ChoiceBanner-StayHomeMarket",
                        'type' => 4
                    ],
                    [
                        'action_title' => "اطلاعات بیشتر",
                        'description' => "تمدید دوره ای ویژه",
                        'icon_url' => "https://cs.goldiran.ir/Redesign-Icons/market.png",
                        'id' => 13,
                        'image_url' => "/goldiran/ad/Plus---Large-FA2.jpg",
                        'referral_link' => "https://cs.goldiran.ir/request",
                        'track_id' => "ChoiceBanner-StayHomeMarket",
                        'type' => 4
                    ],
                ]
            ]
        ];

        return response()->json($result);
    }

    public function getRepairQuestions(){
         $result = [
            ['id' => 1, 'type'=> 'checkbox', 'title' => 'آب را تخلیه نمیکند'],
            ['id' => 2, 'type'=> 'checkbox', 'title' => 'آبگیری نمیکند'],
            ['id' => 3, 'type'=> 'checkbox', 'title' => 'بدنه دستگاه آسیب دیده است'],
            ['id' => 4, 'type'=> 'checkbox', 'title' => 'بدنه دستگاه بیش از حد گرم میشود'],
            ['id' => 5, 'type'=> 'checkbox', 'title' => 'بوی سوختگی میدهد'],
            ['id' => 6, 'type'=> 'checkbox', 'title' => 'دستگاه روشن نمیشود'],
            ['id' => 7, 'type'=> 'checkbox', 'title' => 'صدای غیر عادی میدهد'],
            ['id' => 8, 'type'=> 'checkbox', 'title' => 'صفحه نمایش خطا میدهد'],
            ['id' => 9, 'type'=> 'checkbox', 'title' => 'ظرف ها به خوبی شسته نمیشود'],
            ['id' => 10, 'type'=> 'checkbox', 'title' => 'موتور دستگاه هنگام خاموش شدن لرزش دارد'],
            ['id' => 11, 'type'=> 'checkbox', 'title' => 'کلیدها کار نمیکند'],
            ['id' => 12, 'type'=> 'textarea', 'title' => 'توضیحات بیشتر'],
        ];

        return response()->json($result);
    }

    public function getOpenRequests(){
        $result = [
            [
                'image' => "https://cs.goldiran.ir/pic/gstechnician/9702069/9702069.png",
                'technicianName' => "سیدامیرحسین کاظمی",
                'technicianCode' => '9702602',
                'technicianMobile' => '09120276650',
                'productName'=> 'تلویزیون 55 اینچ الجی',
                'productSerial'=> 'MD5088RT1200000',
                'productModel'=> '12MFT',
                'date'=> '25/12/1399',
                'receipt'=> '552500015223', 
                'type' => 'سرویس و نگهداری',
                'progressTitle'=> 'تخصیص به تکنسین',
                'progressPercent'=> 30
            ],
            [
                'image' => "https://cs.goldiran.ir/pic/gstechnician/9405067/9405067.png",
                'technicianName' => "شهاب الدین حسینی",
                'technicianCode' => '9702611',
                'technicianMobile' => '09120006650',
                'productName'=> 'یخچال فریزر جی پلاس',
                'productSerial'=> 'M88RT12001110',
                'productModel'=> '1522GGF',
                'date'=> '25/12/1399',
                'receipt'=> '552500210023', 
                'type'=> 'تعمیر در محل مشتری',
                'progressTitle'=> 'درخواست به انبار جهت تهیه قطعه',
                'progressPercent'=> 70
            ]
        ];
        return response()->json($result);
    }

    public static function getRegionByCity()
    {
        $id = Input::get('id');
        if (!$id)
            return response()->json(['success' => false, 'message' => 'منطقه مورد نظر یافت نشد'], 400);

        $regions = ((array)$this->gsGetRegionByCity($id));

        if (!$regions) {
            return response()->json(['success' => false, 'message' => 'منطقه برای این شهر یافت نشد'], 400);
        }
        $arrayRegion = (array)$regions['Region'];
        return response()->json(count($arrayRegion) > 1 ? $arrayRegion : [$arrayRegion]);
    }

    public function getParishByRegion()
    {
        $id = Input::get('id');

        if (!$id)
            return response()->json(['success' => false, 'message' => 'محله مورد نظر یافت نشد'], 400);

        $regions = ((array)$this->gsGetParishByRegion($id));

        if (!$regions) {
            return response()->json(['success' => false, 'message' => 'محله برای این منطقه یافت نشد'], 400);
        }
        $arrayRegion = (array)$regions['Region'];
        return response()->json(count($arrayRegion) > 1 ? $arrayRegion : [$arrayRegion]);
    }

    public function insertService()
    {

        $info = Input::get('info');
        $requests = Input::get('r');
        $output = [];

        if (!$info['fname'] || !$info['lname']  || !$info['hometel']  || !$info['mobile']  || !$info['address']  || !$info['cityid'] || !$info['regionId'] || !$info['parishId'])
            return response()->json(['success' => false, 'message' => ' اطلاعات ارسال شده کامل نمی باشد'], 400);

        $info['nationalCode'] = '';
        $productName = [];
        foreach ($requests as $key => $value) {
            if ($value['svctypeid']) {
                try {
                    $product = Product::find($value['productcode']);
                    $value['productcode'] = explode(',', $product->code)[0];
                } catch (\Throwable $th) {
                    return response()->json(['success' => false, 'message' => ' اطلاعات ارسال شده صحیح نمی باشد'], 400);
                }

                $output[] = array_merge($info, $value);
                $productName[explode(',', $product->code)[0]] = $product->name;
            }
        }
        $result = [];
        foreach ($output as $key => $value) {
            try {
                $value['officetel'] = $value['officetel'] ?? " ";
                $value['remark'] = $value['remark'] ?? " ";
                $result[$key]['product'] = $productName[$value['productcode']];
                $result[$key]['service'] = $this->getServiceName($value['svctypeid']);
                sleep(1);
                $result[$key]['code'] = ($this->gsInsertService($value));
            } catch (\Throwable $th) {
                continue;
            }
        }


        if (!$result[$key]['code']) {
            return response()->json(['success' => false, 'message' => 'با عرض پوزش درخواست شما ثبت نشد. لطفا پس از چند دقیقه دوباره تلاش نمائید'], 417);
        }

        return response()->json(['success' => true, 'message' => 'درخواست شما با موفقیت ثبت شد', 'result' => $result]);
    }

    private function getServiceName($id)
    {
        $ary = ['3' => 'نصب و راه اندازی', '4' => 'سرویس دوره ای', '2' => 'تعمیر', '7' => 'تمدید گارانتی'];
        return $ary[$id];
    }

    public function getFollowRequest()
    {
        $rules = array(
            'type'           => 'required',
            'data'           => 'required',
            'captcha'         => 'required|captcha'
        );

        $validator = Validator::make(Input::all(), $rules);
        if ($validator->fails()) {
            return response()->json(['success' => false, 'message' => $validator->errors(), 'captcha' => captcha_src('flat')], 400);
        } else {
            $type = Input::get('type');
            $data = Input::get('data');

            if (!$type || !$data)
                return response()->json(['success' => false, 'message' => 'اطلاعات وارد شده کامل نمی باشد', 'captcha' => captcha_src('flat')], 400);
            $result = $this->gsGetFollowRequest($type, $data);
            if (empty($result))
                return response()->json(['success' => false, 'message' => 'درخواستی با کد وارد شده یافت نشد', 'captcha' => captcha_src('flat')], 400);

            return response()->json((array)($result));
        }
    }

    public function getProductModels()
    {
        $id = Input::get('productid');
        $codes = Product::find($id)->code;
        if (!$codes)
            return response()->json(['success' => false, 'message' => 'مدل خاصی برای این محصول یافت نشد'], 400);

        $models = [];
        foreach (explode(',', $codes) as $key => $value) {
            $models = array_merge((array)($this->gsGetModelByProductCode($value)->string), $models);
        }

        if (!$models) {
            return response()->json(['success' => false, 'message' => 'مدل خاصی برای این محصول یافت نشد'], 400);
        }

        return response()->json($models);
    }

    public function modelLocation()
    {
        $id = Input::get('productid');
        if (!$id) {
            return response()->json(['success' => false, 'message' => ' محصول یافت نشد'], 400);
        }
        $location = Product::find($id)->model_location;
        return response()->json($location);
    }

    public function getManual()
    {
        $rules = array(
            'model'           => 'required',
            'captcha'         => 'required|captcha'
        );

        $validator = Validator::make(Input::all(), $rules);
        if ($validator->fails()) {
            return response()->json(['success' => false, 'message' => $validator->errors(), 'captcha' => captcha_src('flat')], 400);
        } else {
            $model = Input::get('model');

            if (!$model)
                return response()->json(['success' => false, 'message' => 'مدل محصول یافت نشد', 'captcha' => captcha_src('flat')], 400);
            $result = $this->gsGetManual($model);
            if (empty($result))
                return response()->json(['success' => false, 'message' => 'مدل محصول  دارای دفترچه راهنما نمی باشد', 'captcha' => captcha_src('flat')], 400);

            return response()->json((array)($result->model));
        }
    }

    public function getDriver()
    {
        $rules = array(
            'model'           => 'required',
            'captcha'         => 'required|captcha'
        );

        $validator = Validator::make(Input::all(), $rules);
        if ($validator->fails()) {
            return response()->json(['success' => false, 'message' => $validator->errors(), 'captcha' => captcha_src('flat')], 400);
        } else {
            $model = Input::get('model');

            if (!$model)
                return response()->json(['success' => false, 'message' => 'مدل محصول یافت نشد', 'captcha' => captcha_src('flat')], 400);

            $result = ProductDriver::where('model', $model)->pluck('link', 'name');
            if (empty($result))
                return response()->json(['success' => false, 'message' => 'مدل محصول  دارای دفترچه راهنما نمی باشد', 'captcha' => captcha_src('flat')], 400);

            return response()->json($result->toJson());
        }
    }

    public function getWarrantyDate()
    {
        $rules = array(
            'model'           => 'required',
            'serialno'           => 'required',
            'captcha'         => 'required|captcha'
        );

        $validator = Validator::make(Input::all(), $rules);
        if ($validator->fails()) {
            return response()->json(['success' => false, 'message' => $validator->errors(), 'captcha' => captcha_src('flat')], 400);
        } else {
            $model = Input::get('model');
            $serial = Input::get('serialno');
            if (!$model || !$serial)
                return response()->json(['success' => false, 'message' => 'مدل یا سریال محصول صحیح نمی باشد  ', 'captcha' => captcha_src('flat')], 400);

            $result = $this->gsCheckWarranty($model, $serial);

            if (empty($result))
                return response()->json(['success' => false, 'message' => 'گارانتی محصول یافت نشد', 'captcha' => captcha_src('flat')], 400);

            return response()->json(($result));
        }
    }

    public function qustion()
    {

        $this->layout->content = view(
            'goldiran::index.qustion',
            []
        );
    }

    public function getAgents()
    {
        $id = Input::get('id');
        $groupid = Input::get('groupid');
        $provinceid = Input::get('province');

        if (!$id)
            return response()->json(['success' => false, 'message' => 'مدل محصول یافت نشد'], 400);

        $result = $this->gsGetAgents($provinceid, $id);
        if (empty($result))
            return response()->json(['success' => false, 'message' => 'نمایندگی برای این منطقه یافت نشد'], 400);

        return response()->json((array)($result));
    }

    public function technician($code)
    {
        $this->layout = 'account::index.auth.layout';
        if (!$code)
            die('کد ارائه شده مورد قبول نمی باشد.');

        $technician = $this->gsGETTechnicianInfo($code);
        if (!$technician)
            die('در حال حاظر تکنسین فعال  نمی باشد.');

        return view(
            'goldiran::index.technician',
            [
                'technician' => $technician,
            ]
        );
    }
}
