<?php
namespace Modules\Goldiran\Http\Controllers\Index;

use App\Http\Controllers\IndexController;
use Modules\Blog\Models\Article;
use Modules\Goldiran\Models\Product;
use Modules\Home\Models\Banner;
use Modules\Page\Models\PageWidget;

class RepaireController extends IndexController {
    
    /*
    |--------------------------------------------------------------------------
    | Home Controller
    |--------------------------------------------------------------------------
    |
    | This controller renders your application's "dashboard" for users that
    | are authenticated. Of course, you are free to change or remove the
    | controller as you wish. It is just here to get your app started!
    |
     */

    /**
     * Show the application dashboard to the user.
     *
     * @return Response
     */
    public function index($id, $title = '') {
        
        $lastArticles = Article::orderBy('xrank', 'desc')
            ->orderBy('created_at', 'desc')
            ->take(7)
            ->where('xstatus',1)
            ->where('xarticle_top',1)
            ->getWithLocale();

        $banners = Banner::where('xstatus', '1')->where('type',5)->getWithLocale();
        $products = Product::where('show_repaire',1)->orderBy('xrank','desc')->getWithStatus();
        $pagewidgets = PageWidget::with('widgets')->where('page_id',5)->orderBy('xrank','asc')->getWithStatus();
        $this->layout->content = view('goldiran::index.repaire',
            [   
                'lastArticles' => $lastArticles,
                'products' => $products,
                'banners' => $banners,
                'pagewidgets' => $pagewidgets,
            ]);
        
        $this->layout->title = "نماینده مجاز و اصلی تعمیرات ال جی و جی پلاس | خدمات گلدیران";
        $this->layout->description = "با ثبت درخواست جهت سرویس و تعمیرات محصولات ال جی و جی پلاس کارشناسان ما در کوتاه ترین زمان در کنار شما خواهند بود .گلدیران تنها نماینده تعمیرات تلویزیون، یخچال و فریزر، ماشین لباسشویی، ماشین ظرفشویی و ساید بای ساید و... ";
    }

    public function product($id, $title = '') {
        $product = Product::find($id);
        if(!$product) abort(404);
        $title2 = str_replace(' ','-',$product->name);
        
        if($title != 'تعمیر-' . $title2)
            return redirect("/repaire/product/$id/تعمیر-$title2",301);
        
        if($product->redirect_link)
            return redirect($product->redirect_link);

        $lastArticles = Article::orderBy('xrank', 'desc')
            ->orderBy('created_at', 'desc')
            ->take(7)
            ->getWithLocale();

        //$product = Product::find($id);
        $banners = Banner::where('xstatus', '1')->where('type',5)->getWithLocale();
        $pagewidgets = PageWidget::with('widgets')->where('page_id',7)->orderBy('xrank','asc')->getWithStatus();
        $this->layout->content = view('goldiran::index.repaire.product',
            [   
                'lastArticles' => $lastArticles,
                'product' => $product,
                'pagewidgets' => $pagewidgets,
                'banners' => $banners,
            ]);

        $this->layout->title = "تعمیر ".$product->name." ال جی | صفر تا صد اطلاعات فنی ".$product->name;
        $this->layout->description = "هر آنچه باید در مورد تعمیرات ".$product->name." ال جی بدانید و از عهده شما بر میاید را می توانید با مطالعه این مقاله یاد بگیرید عواملی چون : روشن نشدن ".$product->name." و ...";
    }

}
