<?php
namespace Modules\Goldiran\Http\Controllers\Index;

use App\Http\Controllers\IndexController;
use Modules\Blog\Models\Article;
use Modules\Goldiran\Models\Product;
use Modules\Goldiran\Models\Group;
use Modules\Home\Traits\Location;
use Modules\Page\Models\PageWidget;

class PriceController extends IndexController {
    use Location;
    /*
    |--------------------------------------------------------------------------
    | Home Controller
    |--------------------------------------------------------------------------
    |
    | This controller renders your application's "dashboard" for users that
    | are authenticated. Of course, you are free to change or remove the
    | controller as you wish. It is just here to get your app started!
    |
     */

    /**
     * Show the application dashboard to the user.
     *
     * @return Response
     */
    public function index($id, $title = '') {
        $lastArticles = Article::orderBy('xrank', 'desc')
            ->orderBy('created_at', 'desc')
            ->take(7)
            ->where('xstatus',1)
            ->where('xarticle_top',1)
            ->getWithLocale();

        $allProducts = Product::getWithStatus();
        $groups = Group::getWithStatus();
        $productsList = [];
        $groupList = [];
        $brandList = [0 => 'انتخاب برند محصول'];
        $fullBrandList = [];
        $fullGroupList = [];

        foreach (@$groups as $val){
            if($val->parent_id == 0){
                $brandList[$val->id] = $val->name;
                $fullBrandList[] = $val;
            }else{
                $groupList[@$val->parent_id][@$val->id] = @$val->name;
                $fullGroupList[] = $val;
            }
        }
        
        foreach (@$allProducts as $val) {
            $productsList[@$val->group_id][@$val->id] = @$val->name;
        }

        $location = self::getZones();
        
        $this->layout->content = view('goldiran::index.price',
            array_merge([   
                'lastArticles' => $lastArticles,
                'productList' => $productsList,
                'groupList' => $groupList,
                'brandList' => $brandList,
                'fullProductList' => $allProducts,
                'fullBrandList' => $fullBrandList,
                'fullGroupList' => $fullGroupList,
            ],$location));
        
        $this->layout->title = "نماینده مجاز و اصلی تعمیرات ال جی و جی پلاس | خدمات گلدیران";
        $this->layout->description = "با ثبت درخواست جهت سرویس و تعمیرات محصولات ال جی و جی پلاس کارشناسان ما در کوتاه ترین زمان در کنار شما خواهند بود .گلدیران تنها نماینده تعمیرات تلویزیون، یخچال و فریزر، ماشین لباسشویی، ماشین ظرفشویی و ساید بای ساید و... ";
    }

}
