<?php
namespace Modules\Goldiran\Http\Controllers\Index;

use App\Http\Controllers\IndexController;
use Modules\Blog\Models\Article;
use Modules\Home\Models\Banner;
use Modules\Page\Models\PageWidget;

class PeriodicController extends IndexController {
    
    /*
    |--------------------------------------------------------------------------
    | Home Controller
    |--------------------------------------------------------------------------
    |
    | This controller renders your application's "dashboard" for users that
    | are authenticated. Of course, you are free to change or remove the
    | controller as you wish. It is just here to get your app started!
    |
     */

    /**
     * Show the application dashboard to the user.
     *
     * @return Response
     */
    public function index($id, $title = '') {
        
        $lastArticles = Article::orderBy('xrank', 'desc')
            ->orderBy('created_at', 'desc')
            ->take(7)
            ->where('xstatus',1)
            ->where('xarticle_top',1)
            ->getWithLocale();

        
            $banners = Banner::where('xstatus', '1')->where('type',3)->getWithLocale();
            $pagewidgets = PageWidget::with('widgets')->where('page_id',3)->orderBy('xrank','asc')->getWithStatus();

        $this->layout->content = view('goldiran::index.periodic',
            [   
                'lastArticles' => $lastArticles,
                'banners' => $banners,
                'pagewidgets' => $pagewidgets,
            ]);

        $this->layout->title = "سرویس دوره ای محصولات ال جی و جی پلاس | خدمات گلدیران";
        $this->layout->description = "سرویس دوره ای محصولات ال جی و جی پلاس | سرویس نگهداری یخچال و فریزر، ماشین لباسشویی، ماشین ظرفشویی و ساید بای ساید و ...";
    }

}
