<?php namespace Modules\Goldiran\Http\Controllers\Index;

use App\Http\Controllers\IndexController;
use Modules\Blog\Models\Article;
use Modules\Home\Models\Faq;
use Modules\Page\Models\Page;
use Modules\Goldiran\Models\Product;
use Validator;
use Request;
use Input;
use Mail;

class ErrorsController extends IndexController {

	/*
	|--------------------------------------------------------------------------
	| Home Controller
	|--------------------------------------------------------------------------
	|
	| This controller renders your application's "dashboard" for users that
	| are authenticated. Of course, you are free to change or remove the
	| controller as you wish. It is just here to get your app started!
	|
	*/

	/**
	 * Show the application dashboard to the user.
	 *
	 * @return Response
	 */
	public function  index()
	{
        
        $title= "errors";
		$faqs = Faq::where('controller',2)->getWithStatus();
			
		$products = Product::where('show_repaire',1)->getWithStatus()->prepend(new Product(['id' => 0, 'name' => 'همه محصولات']));
      	$this->layout->title2 = trans($title);
        $this->layout->content = view('home::index.faq',[
			'title' => 'خطاهای متداول در دستگاه ها',
			'type' => 'Errors',
			'faqs' => $faqs,
			'products' => $products,
		]);
	}

	public function filter(){

		$str = Input::get('src');
		$type = Input::get('type');

		$products = Product::where('show_repaire',1)->getWithStatus()->prepend(new Product(['id' => 0, 'name' => 'همه محصولات']));
		
		if($str){
			$items = Page::where('type',4)
				->where('xpage_title','like',"%$str%")
				->orWhere('xpage_subtitle','like',"%$str%")
				->orWhere('xpage_desc','like',"%$str%")
				->orderBy('xrank','desc')
				->getWithLocale();
			
			$viewType = "page";
		}else{
			$items = Faq::where('controller',2)
				->when($type, function ($query, $data) {
					return $query->where('type', $data);
				})
				->orderBy('xrank', 'desc')
				->getWithLocale();

			$viewType = null;
		}
			
        $this->layout->content = view('home::index.faq',[
			'title' => 'خطاهای متداول در دستگاه ها',
			'type' => 'Errors',
			'faqs' => $items,
			'products' => $products,
			'viewType' => $viewType,
			'activeGroup' => $type ? $products->where('id',(int)$type)->first()->name : null,
		]);
	
	}
	


	
}
