<?php namespace Modules\Goldiran\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Goldiran\Models\WarehouseType;
use Config;
use Input;
use File;
use App;

class WarehouseTypeController extends BackendController {
    public $title = "warehouseType";

    //## list
    public function index()
    {
        $this->field[] =  array('php' => 'echo $item["id"];', 'name' => trans('language.id'), 'css' => 'width: 10%', 'sortable' => 'id');
        $this->field[] =  array('php' => 'echo $item["name"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'name');
    
        $this->list = WarehouseType::getResult();
        $this->paginate();
    }

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'warehouseType';
    }

    //## edit
    public function edit($id)
    {

        $this->layout->content->list = WarehouseType::find($id);     
        $this->layout->title = 'warehouseType';
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $banner = WarehouseType::updateById($frm, $id);
        
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        $res = WarehouseType::remove($id);
    }

    //## delete logo
    public function deleteImg($id)
    {
        $type = Input::get('type');
        WarehouseType::removeImage($id,$type);
        die('[[OK]]');
    }
}