<?php namespace Modules\Goldiran\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Goldiran\Models\TransferType;
use Config;
use Input;
use File;
use App;

class TransferTypeController extends BackendController {
    public $title = "transferType";

    //## list
    public function index()
    {
        $this->field[] =  array('php' => 'echo $item["id"];', 'name' => trans('language.id'), 'css' => 'width: 10%', 'sortable' => 'id');
        $this->field[] =  array('php' => 'echo $item["name"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'name');
    
        $this->list = TransferType ::getResult();
        $this->paginate();
    }

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'transferType';
    }

    //## edit
    public function edit($id)
    {

        $this->layout->content->list = TransferType::find($id);     
        $this->layout->title = 'transferType';
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $banner = TransferType::updateById($frm, $id);
        
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        $res = TransferType::remove($id);
    }

    //## delete logo
    public function deleteImg($id)
    {
        $type = Input::get('type');
        TransferType::removeImage($id,$type);
        die('[[OK]]');
    }
}