<?php namespace Modules\Goldiran\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Goldiran\Models\Meter;
use Config;
use Input;
use File;
use App;

class MeterController extends BackendController {
    public $title = "meter";

    //## list
    public function index()
    {
        $this->field[] =  array('php' => 'echo $item["id"];', 'name' => trans('language.id'), 'css' => 'width: 10%', 'sortable' => 'id');
        $this->field[] =  array('php' => 'echo $item["name"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'name');
    
        $this->list = Meter::getResult();
        $this->paginate();
    }

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'meter';
    }

    //## edit
    public function edit($id)
    {

        $this->layout->content->list = Meter::find($id);     
        $this->layout->title = 'meter';
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $banner = Meter::updateById($frm, $id);
        
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        $res = Meter::remove($id);
    }

    //## delete logo
    public function deleteImg($id)
    {
        $type = Input::get('type');
        Meter::removeImage($id,$type);
        die('[[OK]]');
    }
}