<?php namespace Modules\Goldiran\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Goldiran\Models\ItemType;
use Config;
use Input;
use File;
use App;

class ItemTypeController extends BackendController {
    public $title = "itemType";

    //## list
    public function index()
    {
        $this->field[] =  array('php' => 'echo $item["id"];', 'name' => trans('language.id'), 'css' => 'width: 10%', 'sortable' => 'id');
        $this->field[] =  array('php' => 'echo $item["name"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'name');
    
        $this->list = ItemType::getResult();
        $this->paginate();
    }

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'itemType';
    }

    //## edit
    public function edit($id)
    {

        $this->layout->content->list = ItemType::find($id);     
        $this->layout->title = 'itemType';
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $banner = ItemType::updateById($frm, $id);
        
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        $res = ItemType::remove($id);
    }

    //## delete logo
    public function deleteImg($id)
    {
        $type = Input::get('type');
        ItemType::removeImage($id,$type);
        die('[[OK]]');
    }
}