<?php namespace Modules\Goldiran\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Goldiran\Models\InquiryType;
use Config;
use Input;
use File;
use App;

class InquiryTypeController extends BackendController {
    public $title = "inquiryType";

    //## list
    public function index()
    {
        $this->field[] =  array('php' => 'echo $item["id"];', 'name' => trans('language.id'), 'css' => 'width: 10%', 'sortable' => 'id');
        $this->field[] =  array('php' => 'echo $item["name"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'name');
    
        $this->list = InquiryType::getResult();
        $this->paginate();
    }

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'inquiryType';
    }

    //## edit
    public function edit($id)
    {

        $this->layout->content->list = InquiryType::find($id);     
        $this->layout->title = 'inquiryType';
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $banner = InquiryType::updateById($frm, $id);
        
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        $res = InquiryType::remove($id);
    }

    //## delete logo
    public function deleteImg($id)
    {
        $type = Input::get('type');
        InquiryType::removeImage($id,$type);
        die('[[OK]]');
    }
}