<?php 
namespace Modules\Goldiran\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Goldiran\Models\Product;
use Modules\Goldiran\Models\Group;
use Input;
use File;
use App;
use Auth;
use Modules\Goldiran\Models\SurveyAnswer;
use Modules\Goldiran\Models\SurveyQuestion;
use Modules\Goldiran\Models\SurveyVoc;

class GoldiranSurveyVocController extends BackendController {
    public $title = "voc";

    //## list
	public function index()
	{
        $this->field[] =  array('php' => 'echo $item["name"];', 'name' => t('title'), 'css' => 'width: 10%', 'sortable' => 'name');
        $this->field[] =  array('php' => 'echo $item["otherid"];', 'name' => t('id'), 'css' => 'width: 10%', 'sortable' => 'otherid');
        $this->field[] =  array('php' => 'echo $item["answer_name"];', 'name' => t('answer'), 'css' => 'width: 10%', 'sortable' => 'answer_name');
        $this->field[] =  array('php' => 'echo $item["order"];', 'name' => trans('language.display rank'), 'css' => 'width: 5%', 'sortable' => 'order');
            

        $this->list = SurveyVoc::getResult();
        $this->paginate();
	}

    //## new
    public function create($id = 0)
    {
        $this->layout->content->list = [1];
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id)
    {
        $this->layout->content->list = SurveyVoc::find($id);
        $this->layout->title = $this->title;
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $product = SurveyVoc::updateById($frm,$id);
        die('[[OK]]');
    }

     //## delete
    public function delete($id)
    {
        if ($id) {
            $res = SurveyVoc::remove($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }
    }


    //## set combo
    public function setCombo()
    {
        $this->layout->answerList = $this->layout->content->answerList = SurveyAnswer::get()->pluck('name','otherid')->prepend('','');
    }
}