<?php 
namespace Modules\Goldiran\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Goldiran\Models\Product;
use Modules\Goldiran\Models\Group;
use Input;
use File;
use App;
use Auth;
use Modules\Goldiran\Models\SurveyAnswer;
use Modules\Goldiran\Models\SurveyConfig;
use Modules\Goldiran\Models\SurveyQuestion;

class GoldiranSurveyQuestionController extends BackendController {
    public $title = "questions";

    //## list
	public function index()
	{
        $this->field[] =  array('php' => 'echo $item["name"];', 'name' => t('title'), 'css' => 'width: 10%', 'sortable' => 'name');
        $this->field[] =  array('php' => 'echo $item["otherid"];', 'name' => t('id'), 'css' => 'width: 10%', 'sortable' => 'otherid');
        $this->field[] =  array('php' => 'echo $item["type_name"];', 'name' => t('type'), 'css' => 'width: 10%', 'sortable' => 'type');
        $this->field[] =  array('php' => 'echo $item["service_type"];', 'name' => t('service type'), 'css' => 'width: 10%', 'sortable' => 'service_type');
        $this->field[] =  array('php' => 'echo $item["order"];', 'name' => trans('language.display rank'), 'css' => 'width: 5%', 'sortable' => 'order');
        $this->field[] =  array('php' => 'echo $item["page_id"];', 'name' => t('page'), 'css' => 'width: 5%', 'sortable' => 'order');
            

        $this->list = SurveyQuestion::getResult();
        $this->paginate();
        $this->layout->content->listBtn['showItems'] = true;
	}

    //## new
    public function create($id = 0)
    {
        $this->layout->content->list = [1];
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id)
    {
        $this->layout->content->list = SurveyQuestion::find($id);
        $this->layout->title = $this->title;
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $product = SurveyQuestion::updateById($frm,$id);
        die('[[OK]]');
    }

     //## delete
    public function delete($id)
    {
        if ($id) {
            $res = SurveyQuestion::remove($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }
    }

    public function editItems($id)
    {
        $this->layout->title = 'items';
        $this->layout->storeMethod = 'storeItems';
        $this->layout->content = view('goldiran::admin.edit.goldiranSurveyQuestionItem');
        $this->layout->content->question = SurveyQuestion::find($id);
       
    }

    public function storeItems($id)
    {
        $frm = Input::get('list');
        $question = SurveyQuestion::find($id);
        SurveyAnswer::syncOneToMany($frm,$question->otherid,'question_id');
       
        die('[[OK]]');
    }


    //## set combo
    public function setCombo()
    {
        $this->layout->content->typeList = SurveyConfig::pluck('name','id');
        $this->layout->typeList = $this->addNullToArray($this->layout->content->typeList);
       // $this->layout->groupList = $this->layout->content->groupList = Group::getWithLocale()->pluck('name','id');
    }
}