<?php 
namespace Modules\Goldiran\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Goldiran\Models\Product;
use Modules\Goldiran\Models\Group;
use Input;
use File;
use App;
use Auth;
use Modules\Goldiran\Models\SurveyAnswer;
use Modules\Goldiran\Models\SurveyQuestion;
use Modules\Goldiran\Models\SurveyVoc;

class GoldiranSurveyAnswerController extends BackendController {
    public $title = "answers";

    //## list
	public function index()
	{
        $this->field[] =  array('php' => 'echo $item["name"];', 'name' => t('title'), 'css' => 'width: 10%', 'sortable' => 'name');
        $this->field[] =  array('php' => 'echo $item["otherid"];', 'name' => t('id'), 'css' => 'width: 10%', 'sortable' => 'otherid');
        $this->field[] =  array('php' => 'echo $item["question_name"];', 'name' => t('question'), 'css' => 'width: 10%', 'sortable' => 'question_name');
        $this->field[] =  array('php' => 'echo $item["order"];', 'name' => trans('language.display rank'), 'css' => 'width: 5%', 'sortable' => 'order');
            

        $this->list = SurveyAnswer::getResult();
        $this->paginate();
        $this->layout->content->listBtn['showItems'] = true;
	}

    //## new
    public function create($id = 0)
    {
        $this->layout->content->list = [1];
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id)
    {
        $this->layout->content->list = SurveyAnswer::find($id);
        $this->layout->title = $this->title;
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $product = SurveyAnswer::updateById($frm,$id);
        die('[[OK]]');
    }

     //## delete
    public function delete($id)
    {
        if ($id) {
            $res = SurveyAnswer::remove($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }
    }

    public function editItems($id)
    {
        $this->layout->title = 'items';
        $this->layout->storeMethod = 'storeItems';
        $this->layout->content = view('goldiran::admin.edit.goldiranSurveyAnswerItem');
        $this->layout->content->answer = SurveyAnswer::find($id);
       
    }

    public function storeItems($id)
    {
        $frm = Input::get('list');
        $answer = SurveyAnswer::find($id);
        SurveyVoc::syncOneToMany($frm,$answer->otherid,'answer_id');
       
        die('[[OK]]');
    }


    //## set combo
    public function setCombo()
    {
        $this->layout->questionList = $this->layout->content->questionList = SurveyQuestion::get()->pluck('name','otherid')->prepend('','');
    }
}