<?php

namespace Modules\Goldiran\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Shop\Models\Product;
use Modules\Goldiran\Traits\GS;
use Modules\Home\Models\Config;
use Modules\Home\Models\Province;
use Modules\Home\Models\County;
use Modules\Home\Models\Parish;
use Modules\Home\Models\Region;

class GoldiranSettingController extends BackendController
{
    use GS;
    public $title = "goldiran setting";

    //## list
    public function index()
    {
        $this->layout->title = trans($this->title);
        $this->layout->custom = true;
        $this->layout->content = view('goldiran::admin.edit.goldiransetting');
    }

    public function updateAllPartNumberPriceQuantity(){
        set_time_limit(0);
        $products = Product::all();
        foreach ($products as $key => $value) {
            if ($value->part_number) {
                $value->getGSPrice();
            }
        }
        return back()->with(['status'=> 'success']);
    }

    public function updateAllPartNumberModels()
    {
        set_time_limit(0);
        $products = Product::all();
        foreach ($products as $key => $value) {
            if ($value->part_number) {
                $this->updatePartNumberModels($value);
            }
        }
        return back()->with(['status'=> 'success']);
    }

    public function updatePartNumberModels($product)
    {
        if (!$product->part_number)
            return;

        $models = ((array) $this->gsModelsByPartNumber($product->part_number));
        
        if(!array_key_exists('models',$models)){
            return;
        }
        $modelArray = [];
        foreach (is_array($models['models']) ? $models['models'] : [$models['models']] as $val) {
            $modelArray[] = ['model' => (string)$val->model];
        }
        
        $product->otherModel()->delete();
        $product->otherModel()->createMany($modelArray);
    }

    public function updateProvince()
    {
        $county = $this->gsGetCity();

        $countyList = [];
        $regionList = [];
        $parishList = [];
        if ($county) {
            foreach ($county as $key => $value) {
                $countyList[] = [
                    'id' => (int) $value->CityCode,
                    'province_id' => (int) $value->ProvinceCode,
                    'name' => (string) $value->CityName
                ];
              
                $region = $this->gsGetRegionByCity((int) $value->CityCode);
                if ($region) {
                    foreach ($region as $key2 => $value2) {
                        $regionList[] = [
                            'id' => (int) $value2->id,
                            'city_id' => (int) $value->CityCode,
                            'name' => (string) $value2->name
                        ];

                        $parish = (array) $this->gsGetParishByRegion((int) $value2->id);
                        if ($parish) {
                            if (!array_key_exists('id', (array) $parish['Region']))
                                $arrayRegion = (array) $parish['Region'];
                            else
                                $arrayRegion = $parish;

                            foreach ($arrayRegion as $key3 => $value3) {
                                if ($value3) {
                                    $parishList[] = [
                                        'id' => (int) $value3->id,
                                        'region_id' => (int) $value2->id,
                                        'name' => (string) $value3->parishName
                                    ];
                                }
                            }
                        }
                    }
                }
            }
        }
       
        County::truncate();
        County::updateById($countyList);

        Region::truncate();
        Region::updateById($regionList);

        Parish::truncate();
        Parish::updateById($parishList);


        die('[ok]');
    }

    //## store
    public function store($id)
    {
        $config = Config::where('xtype', 'version')->where('xconfigid', $id)->first();
        $config = json_decode($config->xconfig_data, true);
        $config['mobile']['version']++;

        $this->createZipFile($config['mobile']['version']);

        $config = json_encode($config);
        Config::updateById(['xconfig_data' => $config], $id);

        return back();
    }
}
