<?php namespace Modules\Goldiran\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Config;
use File;
use Input;
use Modules\Goldiran\Models\Group;

class GoldiranProductGroupController extends BackendController {
    public $title = "group";

    //## list
    public function index() {
        $this->field[] = array('php' => 'echo \'<div style="text-align: center;"><img src="/pic/group/\' . $item["id"] . "w120h100c1/". str_random() . ".png?nocache=1" . \'" alt="" /></div>\';',
            'name' => trans('language.picture'), 'css' => 'width: 3%');
        $this->field[] = array('php' => 'echo $item["name"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'name');

        $this->field[] = array('php' => 'echo $item["xrank"];', 'name' => trans('language.display rank'), 'css' => 'width: 5%', 'sortable' => 'xrank');

        $this->list = Group::getResult();
        $this->paginate();
    }

    //## new
    public function create($id = 0) {
        $this->layout->title = $this->title;
        $this->layout->content->subList = [1];
        $this->layout->content->parentList = Group::get()->pluck('name','id')->prepend('بدون والد',0);
    }

    //## edit
    public function edit($id) {
        $category = Group::find($id);
        $this->layout->content->list = $category;
        $this->layout->content->imgExist = File::exists(config('upload.' . config('app.controller')) . "/$id");
        $this->layout->content->menuExist = File::exists(config('upload.' . config('app.controller')) . "/menu" . "/$id");

        $this->layout->title = $this->title;
        $this->layout->content->parentList = Group::where('id','<>',$id)->get()->pluck('name','id')->prepend('بدون والد',0);

        $subList = $category->childs;
        $this->layout->content->subList = $subList->count() ? $subList : [1];
        $this->layout->content->imageExist = File::exists(Config::get('upload.' . Config::get('app.controller')) . "/$id");
        foreach ($subList as $sub) {
            $this->layout->content->subExist[$sub['xsubcategoryid']] = File::exists(Config::get('upload.' . Config::get('app.controller')) . "/sub/" . $sub['xsubcategoryid']);
        }
    }

    //## store
    public function store($id) {
        $frm = Input::get('frm');
        $category = Group::updateById($frm, $id);

        $subList = Input::get('subList');
        $subImg = [];
        if ($subList) {
            foreach ($subList as $key => $sub) {
                $sub['xcategoryid'] = $category->xcategoryid;
                $sb = Group::updateById($sub, @$sub['xsubcategoryid']);
                $subImg[$key] = $sb->xsubcategoryid;
            }
        }
        $this->saveFile($id, $subImg);

        die('[[OK]]');
    }

    //## delete
    public function delete($id) {
        if ($id) {
            $res = Group::remove($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }
    }

    //## delete logo
    public function deleteImg($id) {
        $type = Input::get('type');
        if ($type == 'menu') {
            File::delete(config('upload.' . config('app.controller')) . "/" . $type . "/$id");
        } else {
            File::delete(config('upload.' . config('app.controller')) . "/$id");
        }
        die('[[OK]]');
    }

    //## deleteGallery
    public function deleteGallery($id) {
        if ($id) {
            $res = SubCategory::remove($id);
            if (!$res) {
                alert(trans('language.this record can not be removed'));
                die('[[Error]]');
            } else {
                File::delete(Config('upload.' . Config('app.controller')) . "/sub/$id");
                die('[[OK]]');
            }
        } else {
            die('[[Error]]');
        }
    }
}