<?php 
namespace Modules\Goldiran\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Goldiran\Models\Product;
use Modules\Goldiran\Models\Group;
use Input;
use File;
use App;
use Auth;

class GoldiranProductController extends BackendController {
    public $title = "product";

    //## list
	public function index()
	{
        $this->field[] =  array('php' => 'echo \'<div style="text-align: center;"><img src="/pic/goldiranproduct.image/\' . $item["id"] . "w120h100c1/". str_random() . ".png?nocache=1" . \'" alt="" /></div>\';',
           'name' => trans('language.picture'), 'css' => 'width: 3%');

        $this->field[] =  array('php' => 'echo $item["name"];', 'name' => t('title'), 'css' => 'width: 10%', 'sortable' => 'name');
        $this->field[] =  array('php' => 'echo $item["group_id"];', 'name' => t('group'), 'css' => 'width: 10%', 'sortable' => 'group_id');
        $this->field[] =  array('php' => 'echo $item["code"];', 'name' => t('code'), 'css' => 'width: 10%', 'sortable' => 'code');
        
        $this->field[] =  array('php' => 'echo $item["xrank"];', 'name' => trans('language.display rank'), 'css' => 'width: 5%', 'sortable' => 'xrank');
            

        $this->list = Product::getResult();
        $this->paginate();
	}

    //## new
    public function create($id = 0)
    {
        $this->layout->content->list = [1];
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id)
    {
        $this->layout->content->list = Product::find($id);
        $this->layout->content->imgExist = File::exists(config('upload.' . config('app.controller')) . "/image/$id");
        $this->layout->content->bannerExist = File::exists(config('upload.' . config('app.controller')) ."/banner". "/$id");
        $this->layout->title = $this->title;
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $product = Product::updateById($frm,$id);
        $this->saveFile($product->id);
        die('[[OK]]');
    }

     //## delete
    public function delete($id)
    {
        if ($id) {
            $res = Product::remove($id);
            File::delete(config('upload.' . config('app.controller'))  . "/image/$id");
            File::delete(config('upload.' . config('app.controller')) . "/banner/$id");
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }
    }

    //## delete logo
    public function deleteImg($id)
    {
        $type = Input::get('type');
        File::delete(config('upload.' . config('app.controller'))  ."/".$type . "/$id");
        die('[[OK]]');
    }

    //## set combo
    public function setCombo()
    {
        $this->layout->groupList = $this->layout->content->groupList = Group::getWithLocale()->pluck('name','id');

    }
}