<?php 
namespace Modules\Goldiran\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Goldiran\Models\Product;
use Modules\Goldiran\Models\Group;
use Input;
use File;
use App;
use Auth;
use Modules\Goldiran\Models\ProductDriver;

class GoldiranDriverController extends BackendController {
    public $title = "driver";

    //## list
	public function index()
	{
       
        $this->field[] =  array('php' => 'echo $item["name"];', 'name' => t('title'), 'css' => 'width: 10%', 'sortable' => 'name');
        $this->field[] =  array('php' => 'echo $item["model"];', 'name' => t('model'), 'css' => 'width: 10%', 'sortable' => 'model');
        
        $this->field[] =  array('php' => 'echo $item["xrank"];', 'name' => trans('language.display rank'), 'css' => 'width: 5%', 'sortable' => 'xrank');
            

        $this->list = ProductDriver::getResult();
        $this->paginate();
	}

    //## new
    public function create($id = 0)
    {
        $this->layout->content->list = [1];
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id)
    {
        $this->layout->content->list = ProductDriver::find($id);
        $this->layout->title = $this->title;
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $product = ProductDriver::updateById($frm,$id);
        
        die('[[OK]]');
    }

     //## delete
    public function delete($id)
    {
        if ($id) {
            $res = ProductDriver::remove($id);
            
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }
    }

  

    //## set combo
    public function setCombo()
    {
        

    }
}