<?php namespace Modules\Goldiran\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Goldiran\Models\Duration;
use Config;
use Input;
use File;
use App;

class DurationController extends BackendController {
    public $title = "duration";

    //## list
    public function index()
    {
        $this->field[] =  array('php' => 'echo $item["id"];', 'name' => trans('language.id'), 'css' => 'width: 10%', 'sortable' => 'id');
        $this->field[] =  array('php' => 'echo $item["name"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'name');
    
        $this->list = Duration::getResult();
        $this->paginate();
    }

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'duration';
    }

    //## edit
    public function edit($id)
    {

        $this->layout->content->list = Duration::find($id);     
        $this->layout->title = 'duration';
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $banner = Duration::updateById($frm, $id);
        
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        $res = Duration::remove($id);
    }

    //## delete logo
    public function deleteImg($id)
    {
        $type = Input::get('type');
        Duration::removeImage($id,$type);
        die('[[OK]]');
    }
}