<?php namespace Modules\Goldiran\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Goldiran\Models\CountPerMonth;
use Config;
use Input;
use File;
use App;

class CountPerMonthController extends BackendController {
    public $title = "countPerMonth";

    //## list
    public function index()
    {
        $this->field[] =  array('php' => 'echo $item["id"];', 'name' => trans('language.id'), 'css' => 'width: 10%', 'sortable' => 'id');
        $this->field[] =  array('php' => 'echo $item["name"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'name');
    
        $this->list = CountPerMonth::getResult();
        $this->paginate();
    }

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'countPerMonth';
    }

    //## edit
    public function edit($id)
    {

        $this->layout->content->list = CountPerMonth::find($id);     
        $this->layout->title = 'countPerMonth';
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $banner = CountPerMonth::updateById($frm, $id);
        
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        $res = CountPerMonth::remove($id);
    }

    //## delete logo
    public function deleteImg($id)
    {
        $type = Input::get('type');
        CountPerMonth::removeImage($id,$type);
        die('[[OK]]');
    }
}