<?php namespace Modules\Goldiran\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Goldiran\Models\CountPerDay;
use Config;
use Input;
use File;
use App;

class CountPerDayController extends BackendController {
    public $title = "countPerDay";

    //## list
    public function index()
    {
        $this->field[] =  array('php' => 'echo $item["id"];', 'name' => trans('language.id'), 'css' => 'width: 10%', 'sortable' => 'id');
        $this->field[] =  array('php' => 'echo $item["name"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'name');
    
        $this->list = CountPerDay::getResult();
        $this->paginate();
    }

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'countPerDay';
    }

    //## edit
    public function edit($id)
    {

        $this->layout->content->list = CountPerDay::find($id);     
        $this->layout->title = 'countPerDay';
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $banner = CountPerDay::updateById($frm, $id);
        
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        $res = CountPerDay::remove($id);
    }

    //## delete logo
    public function deleteImg($id)
    {
        $type = Input::get('type');
        CountPerDay::removeImage($id,$type);
        die('[[OK]]');
    }
}