<?php namespace Modules\Goldiran\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Goldiran\Models\ConsultingType;
use Config;
use Input;
use File;
use App;

class ConsultingController extends BackendController {
    public $title = "consulting";

    //## list
    public function index()
    {
        $this->field[] =  array('php' => 'echo $item["id"];', 'name' => trans('language.id'), 'css' => 'width: 10%', 'sortable' => 'id');
        $this->field[] =  array('php' => 'echo $item["name"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'name');
    
        $this->list = ConsultingType::getResult();
        $this->paginate();
    }

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'consulting';
    }

    //## edit
    public function edit($id)
    {

        $this->layout->content->list = ConsultingType::find($id);     
        $this->layout->title = 'consulting';
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $banner = ConsultingType::updateById($frm, $id);
        
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        $res = ConsultingType::remove($id);
    }

    //## delete logo
    public function deleteImg($id)
    {
        $type = Input::get('type');
        ConsultingType::removeImage($id,$type);
        die('[[OK]]');
    }
}