<?php namespace Modules\Goldiran\Entities;

use DB;
use App; 
use Modules\Goldiran\Traits\GS;
use Modules\Goldiran\Models\SurveyQuestion;
use Modules\Goldiran\Models\SurveyVoc;

class Survey
{
    use GS;
    public static function getQuestions($pageId,$serviceType,$productCode,$isLogestic=true,$repairCode=null){
        
        //if($isLogestic) $serviceType += 300;
        //elseif($repairCode == 'RE16') $serviceType += 100; // ایرادی مشاهده نشد
        //elseif($repairCode == 'RE21') $serviceType += 200; // با هزینه موافقت نمی کند

        $srvs = [0,$serviceType];
        if($serviceType != 4) $srvs[] = 1000;
        
        $questions = SurveyQuestion::where('page_id',$pageId)->whereIn('service_type',$srvs)->when($productCode,function($query,$data){
            return $query->where(function($query) use ($data){
                $query->where('product',$data)->orWhereNull('product');
            });
        })->orderBy('order','desc')->get();
        
        $voc = self::getVocByAnswer($serviceType);
        $voclist = [];
        foreach ($voc as $key => $value) {
            $voclist[$value->answer_id][$value->id]=$value->name;
        }

        return [   
            'questions' => $questions,
            'voc' => $voc,
            'vocList' => $voclist,
        ];
    }

    private static function getVocByAnswer($serviceType){
        return SurveyVoc::where('service_type',$serviceType)->orWhereNull('service_type')->orderBy('order','desc')->get();
    }

    public static function register($answers, $voc, $serviceNo, $customerCode, $comment = null){
        $answer = [];
        foreach (@$answers as $key => $value) {
            $answer[] = ['quesId' => $key, 'ansId' => $value];
        }
        preg_match_all('/([0-9]+)/',$voc, $vocMatch);
        foreach (@$vocMatch[1] as $key => $value) {
            $answer[] = ['quesId' => 2018, 'ansId' => $value];
        }
        
        $array= ['serviceno' => $serviceNo, 'customerCode' => $customerCode, 'hpResult' => json_encode($answer), 'customerComment' => $comment ? array_first($comment) : ' '];
        $instance = new static();
        $result = $instance->gsInsertRegisterNps($array);

        return $result;
    }

    public static function registerTechnician($questionId, $answerId, $serviceNo, $customerCode, $comment = null){
        
        $array= ['serviceNo' => $serviceNo, 'mobile' => $customerCode, 'questionId' => (int)$questionId, 'answerId' => (int)$answerId];
        $instance = new static();
        $result = $instance->gsInsertHCRegister($array);

        return $result;
    }
}