<?php
namespace Modules\Festival\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Input;
use Modules\Book\Models\Book;
use Modules\Shop\Models\Product;
use Modules\Festival\Models\Festival;

class FestivalController extends BackendController
{
    public $title = "festival";

    //## list
    public function index()
    {
        $this->field[] = array('php' => 'echo $item["xfestival_title"];', 'name' => @t('name'), 'css' => 'width: 10%', 'sortable' => 'xfestival_title');
        $this->field[] = array('php' => 'echo FarsiLib::g2jDate($item["expaire_at"],true);', 'name' => @trans('language.expaire'), 'css' => 'width: 10%');
        $this->field[] = array('php' => 'echo $item["xrank"];', 'name' => trans('language.display rank'), 'css' => 'width: 10%', 'sortable' => 'xrank');
        $this->field[] = array('php' => 'echo htmlStatus($item["xstatus"],["1"=>"success","0"=>"danger"]);', 'name' => @t('status'), 'css' => 'width: 10%', 'sortable' => 'xstatus');

        $this->list = Festival::getResult();
        $this->paginate();
        $this->layout->content->listBtn['showItems'] = true;
    }

    //## new
    public function create($id = 0)
    {
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id)
    {
        $this->layout->content->list = Festival::find($id);
        $this->layout->title = $this->title;
    }
    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $festival = Festival::updateById($frm, $id);
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        Festival::remove($id);
    }

    public function editItems($id)
    {
        $this->layout->title = 'items';
        $this->layout->storeMethod = 'storeItems';
        if (config('app.shop') == 'product') {
            $this->layout->content = view('festival::admin.edit.festivalItems');
            $this->layout->content->productList = Product::pluck('name', 'id');
        } else {
            $this->layout->content = view('festival::admin.edit.festivalBookItems');
            $this->layout->content->bookList = Book::pluck('xbook_title', 'xbookid');
        }
        $this->layout->content->festival = Festival::find($id);
    }

    public function storeItems($id)
    {
        $frm = Input::get('frm');
        $festival = Festival::find($id);

        if (config('app.shop') == 'product') {
            $festival->products()->detach();
            foreach ($frm as $key => $value) {
                $festival->products()->attach($value['id'], [
                    'xdiscount' => $value['xdiscount'],
                    'maxbuy' => $value['maxbuy'],
                ]);
            }
        } else {

            $festival->books()->detach();
            foreach ($frm as $key => $value) {
                $festival->books()->attach($value['xbookid'], [
                    'xdiscount' => $value['xdiscount'],
                ]);
            }
        }

        die('[[OK]]');
    }

    public function deleteItem($id, $festid)
    {
        $festival = Festival::find($festid);
        if (config('app.shop') == 'product')
            $festival->products()->detach($id);
        else
            $festival->books()->detach($id);
        die('[[OK]]');
    }

    //## set combo
    public function setCombo()
    {
        
    }
}
