<?php namespace Modules\Core\Models;

use DB;
use stdClass;
use App\Models\Model;
use App;

class Core extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'xxcore';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'xcoreid';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    protected $guarded = ['xcoreid'];

    protected $casts = [
        'xrank' => 'int',
    ];

    /**
     * Get the book for the author.
     */
    public function books()
    {
       return $this->hasMany(Book::class,'xcoreid');
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult()
    {
        $instance = new static();

        $res = DB::table($instance->table)
            ->select(['*', "{$instance->primaryKey} AS xid"]);

        return $res;
    }

    public static function updateById($data,$id=0)
    {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id],$data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id)
    {
        $instance = new static();

        if ($id){
            $res = $instance->destroy($id);
            parent::deleteFile($id);
            die('[[OK]]'); 
        }
        else
            die('[[Error]]');
        return $res;
    }
}