<?php

namespace Code16\Sharp\Form\Fields;

use Code16\Sharp\Form\Fields\Formatters\SelectFormatter;
use Code16\Sharp\Form\Fields\Utils\SharpFormFieldWithDataLocalization;
use Code16\Sharp\Form\Fields\Utils\SharpFormFieldWithOptions;

class Select extends Field
{

    public $component = 'core-select-field';
    /**
     * @var array
     */
    protected $options;

    /**
     * @var bool
     */
    protected $multiple = false;

    /**
     * @var int
     */
    protected $maxSelected = null;


    /**
     * @param bool $multiple
     * @return $this
     */
    public function setMultiple(bool $multiple = true)
    {
        $this->multiple = $multiple;

        return $this;
    }

    /**
     * @param int $maxSelected
     * @return $this
     */
    public function setMaxSelected(int $maxSelected)
    {
        $this->maxSelected = $maxSelected;

        return $this;
    }

    /**
     * @return static
     */
    public function setMaxSelectedUnlimited()
    {
        $this->maxSelected = null;

        return $this;
    }

    /**
     * @return bool
     */
    public function multiple()
    {
        return $this->multiple;
    }

    /**
    *  @param collection|array $options
    *  @return $this
    */
    public function setOptions($options = null)
    {
        $this->options = self::makeOptions($options);

        return $this;
    }


    /**
    *  @return collection
    */
    public function options()
    {
        if (!$this->options)
            $this->options = collect($this->model->fetchEnum($this->field));
        
        return $this->options;
    }

    /**
     * @param array|Collection $options
     * @return array
     */
    protected static function makeOptions($options)
    {
        if(! sizeof($options)) {
            return null;
        }

        $options = collect($options);

        if((is_array($options->first()) || is_object($options->first()))
            && isset(((array)$options->first())["id"])) {
            // We assume that we already have ["id", "label"] in this case
            return $options->map(function ($item,$key){
                return $item['id'] => $item['label'];
            })->all();
        }

        // Simple [key => value] array case
        return $options->all();
    }

    /**
     * @return array
     */
    protected function validationRules()
    {
        return [
            "options" => "array",
            "multiple" => "boolean",
            "maxSelected" => "int"
        ];
    }

    /**
     * @return array
     * @throws \Code16\Sharp\Exceptions\Form\SharpFormFieldValidationException
     */
    public function toArray(): array
    {
        return parent::buildArray([
            "options" => $this->options,
            "multiple" => $this->multiple,
            "maxSelected" => $this->maxSelected,
            "localized" => $this->localized
        ]);
    }
}