<?php
namespace Modules\Core\Entities\Fields;

class Badge extends Field
{
    // How to use:
    //     Badge::make('Field')
        //    ->options($options)
        //    ->colors([
        //       'option1' => [
        //           'background' => '#ffffff',
        //           'color' => '#000000'
        //       ],
        //       'option2' => '#000000'
        //    ]);

    /**
     * The field's component.
     *
     * @var string
     */
    public $component = 'core-badge-field';
    /**
     * Map of values to colors to be used as badge colors.
     *
     * @param $map
     * @return Badge
     */
    public function colors($map)
    {
        return $this->withMeta(['colorMap' => $map]);
    }
}