<?php
namespace Modules\Core\Entities;

class Builder
{
    
    /**
     * @var array
     */
    private $filters;
    private $fields;
    private $order;
    private $data;
    
    //paginate variable
    private $count;
    private $perPage;

    public function __construct(array $fields, array $filters = [])
    {
        $this->fields = $fields;
        $this->filters = $filters;
    }


    public function transformItems($items)
    {
        return array_filter(array_map([$this, 'applyFilters'], $items));
    }

    protected function applyFilters($item)
    {
        if (is_string($item)) {
            return $item;
        }
        foreach ($this->filters as $filter) {
            $item = $filter->transform($item, $this);
        }
        if (isset($item['header'])) {
            $item = $item['header'];
        }
        return $item;
    }

    protected function applyOrder($item)
    {
        //Order['field' => field, 'dir'=> Enum::ORDER_DESC]

    }

    protected function createIndex($view = 'backend.list', $params = [], $callBack = '')
    {
        //## run clouser after list 
        if (is_callable($view)) {
            $this->list = $view($this->list);
            $view = 'backend.list';
        } 

        if (is_callable($params)) {
            $this->list = $params($this->list);
            $params = [];
        }
        
        if (is_callable($callBack)) {
            $this->list = $callBack($this->list);
        }
    }

    protected function paginate()
    {
        if (!$this->data)
            return null;

        if (!$this->count)
            $this->computeCount();

        return new Paginator($this->data, $this->count, $this->perPage, null, [
            'path' => Request::url(),
            'query' => Request::query()
        ]);
    }

    protected function makeForm($view = 'backend.list', $params = [], $callBack = '')
    {
        if (is_callable($view)) {
            $this->data = $view($this->data);
            $view = 'backend.list';
        } 

        if (is_callable($params)) {
            $this->data = $params($this->data);
            $params = [];
        }
        
        if (is_callable($callBack)) {
            $this->data = $callBack($this->data);
        }

        $this->data = $this->paginate();

        $params = ($params ? $params : [
            'list' => $this->data, 
            'field' => @$this->field
        ]);   
        
        if (Request::ajax()) {
            $this->layout = view('backend.ajax');
        } 
        if ($view) {
            $this->layout->content = (is_object($view) ? $view : view($view, $params));    
        }
    }
}