@section('content')
    <div class="col-md-12">
        <div class="table-responsive">
            <table class="table table-bordered table-striped">               
                <tr>
                    <td>@lang('language.name'):</td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            
                            @if(@$list)
                                {{$list->user->xname.' '.$list->user->xfamily}}
                            @endif
                            </div>
                        </div>
                    </td>
                </tr>

                <tr>
                    <td>@lang('language.type'):</td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            
                                {{@t(camel_case(class_basename(@$list->xcommentable_type)))}}
                            </div>
                        </div>
                    </td>
                </tr>

                 <tr>
                    <td>@t('item'):</td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                                @var('table',$list->commentable->getTable())
                                @if($table == 'shop_product')
                                    <a href="/product/detail/{{$list->commentable->id}}/{{$list->commentable->name}}" target="_blank">{{$list->commentable->name}}</a>
                                @elseif($table == 'xxarticle')
                                    <a href="/blog/{{$list->commentable->xarticle_title}}" target="_blank">{{$list->commentable->xarticle_title}}</a>
                                @elseif($table == 'widget_page')
                                    <a href="/{{$list->commentable->page->url}}" target="_blank">{{$list->commentable->page->title}}</a>
                                @endif
                            </div>
                        </div>
                    </td>
                </tr>

                 <tr>
                    <td>@lang('language.date'):</td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                                {{FarsiLib::g2jDate(date('m/d/Y H:i:s',@$list->xcomment_date),true)}}
                            </div>
                        </div>
                    </td>
                </tr>

               <tr>
                    <td>@t('content'):</td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            
                            {!! Form::textarea('frm[xcomment_content]', @$list['xcomment_content'], array('class' => 'form-control', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>

                <tr>
                    <td>@lang('language.display rank'): </td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[xrank]', @$list['xrank'], array('class' => 'form-control', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>

                <tr>
                    <td>@t('approve'):</td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                                {!! Form::hidden('frm[xcomment_approved]', 0)!!}
                               <label class="el-switch el-switch-green">
                                {!! Form::checkbox('frm[xcomment_approved]', 1, @$list['xcomment_approved'],array('class'=>'no-checker'))  !!} 
                                    <span class="el-switch-style"></span>
                                </label>
                            </div>
                        </div>
                    </td>
                </tr>

            </table>
            
        </div>
    </div>
@stop