<?php namespace Modules\Comment\Models;

use App\Models\Model;
use DB;
use Modules\Account\Models\UserInfo;

class Comment extends Model {
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'xxcomment';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'xcommentid';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    protected $guarded = ['xcommentid'];

    protected $casts = [
        'xuserid' => 'int',
        'xcommentable_id' => 'int',
        'xparentid' => 'int',
        'xcomment_approved' => 'bool',
        'xcomment_date' => 'timestamp',
        'xrank' => 'int',
    ];

    public $lang = false;

    /**
     * Get all of the owning commentable models.
     */
    public function commentable() {
        return $this->morphTo('xcommentable', 'xcommentable_type', 'xcommentable_id');
    }

    /**
     * Get owner commentable models.
     */
    public function user() {
        return $this->belongsTo(UserInfo::class, 'xuserid');
    }

    public function replies()
    {
        return $this->hasMany(Comment::class, 'xparentid')->where('xcomment_approved',1);
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        $res = DB::table("{$instance->table} as c")
            ->leftJoin('xxsecurity_userinfo as ui', 'c.xuserid', '=', 'ui.xuserid')
            ->orderBy('xcomment_date','desc')
            ->select(['c.*', "{$instance->primaryKey} AS xid", DB::Raw("CONCAT(ui.xname, ' ', ui.xfamily) AS xfullname"),"xmobile"]);

        return $res;
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();

        if ($id) {
            $res = $instance->destroy($id);
            parent::deleteFile($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }

        return $res;
    }
}