<?php namespace Modules\Comment\Http\Controllers\Index;

use App\Http\Controllers\IndexController;
use Auth;
use Input;
use Modules\Shop\Models\Product;
use Modules\Blog\Models\Article;
use Illuminate\Support\Carbon;
use Modules\Page\Models\PageWidget;
use Redirect;
use Validator;
use Request;

class CommentController extends IndexController {
    
    /*
    |--------------------------------------------------------------------------
    | Home Controller
    |--------------------------------------------------------------------------
    |
    | This controller renders your application's "dashboard" for users that
    | are authenticated. Of course, you are free to change or remove the
    | controller as you wish. It is just here to get your app started!
    |
     */

    /**
     * Show the application dashboard to the user.
     *
     * @return Response
     */
    public function index() {
        return redirect('/');
    }

    public function addComment() {
        
        $validator = Validator::make(Request::all(), [
			'id' => 'bail|required|numeric',
			'type' => 'required',
			'commentDesc' => 'required|min:15',
			'captcha' => 'required|captcha'
		]);

		if ($validator->fails()) {
            return response()->json(['success' => false, 'message' => $validator->errors(), 'type' => 0, 'captcha' => captcha_src('flat')],422); 
        }
        
        $type = Input::get('type');
        $id = Input::get('id');
        $user = Auth::user();
        $parent = Input::get('parent') ?? 0;
        $comment = Input::get('commentDesc');
        
        if(!$user){
            return response()->json(['success' => false, 'message' => 'لطفا در سیستم وارد شوید', 'type' => 0],401); 
        }

        $comment = [
            'xuserid' => $user->xuserid,
            'xcomment_content' => $comment,
            'xparentid' => $parent,
            'xcomment_date' => Carbon::now(),
        ];

        try {
            switch ($type) {
                case 'article':
                    $commentable =  Article::find($id);
                    break;
                case 'product':
                    $commentable =  Product::find($id);
                    break;
                case 'widget':
                    $commentable =  PageWidget::find($id);
                    break;
                default:
                    return Redirect::back()->with('commentStatus', 'failed');
                    break;
            }
            if($commentable) {
                $commentable->comments()->create($comment);
                return response()->json(['success' => true, 'message' => ' با تشکر، نظر شما ثبت گردید و پس از تایید در وب سایت نمایش داده خواهد شد', 'type' => 100]); 
            }
            
            
        } catch (\Throwable $th) {
            return response()->json(['success' => false, 'message' => 'امکان ثبت نظر شما مقدور نمی باشد. لطفا دوباره تلاش کنید.', 'type' => 1, 'captcha' => captcha_src('flat')],422); 
        }
        
        return response()->json(['success' => false, 'message' => 'امکان ثبت نظر شما مقدور نمی باشد. لطفا دوباره تلاش کنید.', 'type' => 1, 'captcha' => captcha_src('flat')],422); 
        // if($type == 'article'){
        //     $article = Article::find($id);
        //     if($article){
        //         $article->comments()->create($comment);
        //         return response()->json(['success' => true, 'message' => ' با تشکر، نظر شما ثبت گردید و پس از تایید در وب سایت نمایش داده خواهد شد', 'type' => 100]); 
        //     }
        //     return response()->json(['success' => false, 'message' => 'امکان ثبت نظر شما مقدور نمی باشد. لطفا دوباره تلاش کنید.', 'type' => 1, 'captcha' => captcha_src('flat')],422); 

        // }elseif($type == 'product'){
        //     if ($user) {
        //         $product = Product::find($id);
        //         if($product){
        //             $product->comments()->create($comment);
        //             return Redirect::back()->with('commentStatus', 'success');
        //         }
        //         return Redirect::back()->with('commentStatus', 'failed');
        //     } else {
        //         return redirect('User/login');
        //     }
        // }

        //return Redirect::back()->with('commentStatus', 'failed');
    }

   
}
