<?php namespace Modules\Comment\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Comment\Models\Comment;
use Modules\Book\Models\Book;
use Config;
use Input;
use File;
use App;
use DB;
use Modules\Page\Models\PageWidget;

class CommentController extends BackendController {
    public $title = "comment";

    //## list
	public function index()
	{
        $this->field[] =  array('php' => 'echo $item["xfullname"];', 'name' =>  @t('name'), 'css' => 'width: 10%', 'sortable' => 'xuserid');
        $this->field[] =  array('php' => 'echo $item["xmobile"];', 'name' =>  @t('mobile'), 'css' => 'width: 10%', 'sortable' => 'xmobile');
        $this->field[] =  array('php' => 'echo t(camel_case(class_basename($item["xcommentable_type"])));', 'name' =>  @t('type'), 'css' => 'width: 10%', 'sortable' => 'xuserid');
        $this->field[] =  array('php' => 'echo Str::words($item["xcomment_content"],40);', 'name' =>  @t('description'), 'css' => 'width: 60%;word-break: break-all;');
        $this->field[] =  array('php' => 'echo FarsiLib::g2jdate($item["xcomment_date"],true);', 'name' =>  @t('date'), 'css' => 'width: 10%');
        $this->field[] =  array('php' => 'echo htmlStatus($item["xcomment_approved"],["1"=>"success","0"=>"danger"]);', 'name' =>  @t('approve'), 'css' => 'width: 5%');

        $this->list = Comment::getResult()
            ->whereRaw($this->query->where)
            ->orderByRaw($this->query->order)
            ->havingRaw($this->query->having);
            
        $this->paginate();        
        
	}

    //## new
    public function create($id = 0)
    {
        $this->layout->title = $this->title;
        $comment = new Comment(['xcomment_content' => 'A new comment.']);
        $book = Book::find(8);
        $book->comments()->save($comment);
    }

    //## edit
    public function edit($id)
    {
        $comment = Comment::find($id);
        
        // $class = $comment->xcommentable_type;
        // $property = str_contains($class,'Artice') ? 'xarticle_title' : 'name';
        
        // $item = $class::where('xarticleid',$comment->xcommentable_id);
        
        $this->layout->content->models = ['xbook_title'=>Book::class,'xauthor_name'=>Author::class];
        $this->layout->content->list = Comment::find($id);
        $this->layout->content->imgExist = File::exists(config('upload.' . config('app.controller')) . "/$id");
        $this->layout->title = $this->title;
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $book = Comment::updateById($frm,$id);
        die('[[OK]]');
        
    }

    //## delete
    public function delete($id)
    {
        Comment::remove($id);
        
    }

    //## set combo
    public function setCombo()
    {
    
         $this->layout->GroupList = $this->layout->content->GroupList = [1];
         $this->layout->SubGroupList  = $this->layout->content->SubGroupList  = [1];
    }

}