<?php

namespace Modules\Cart\Traits;
use Config;
use Modules\Cart\Models\Copoun;
use Modules\Book\Models\Book;

trait Discount {
    private function checkDiscount() {
        $totals = $this->getSubTotalDiscount();
        $total = $totals['subtotal'] - $totals['notComputTotal'];
        $copoun = $this->getCopounData($total,$totals['productsId']);
        $extra = $this->getExtraDiscount($total);
        $special = $this->getSpecial();

        $computedDiscount = 0;
        $accepted = "null";
        if ($extra['discount']) {
            $computedDiscount = $extra['discount'];
            $accepted = "extra";
        }

        if ($copoun && $copoun['discount']) {
            $computedDiscount = $copoun['discount'];
            $accepted = "copoun";
        }

        if ($totals['discount']) {
            $computedDiscount = $totals['discount'];
            $accepted = "product discount";
        }

        if ($special) {
            $computedDiscount += $special['discount'];
        }

        $discountDetail = [
            'copoun' => [
                'id' => ($copoun && $copoun['model']) ? $copoun['model']->xcopounid : null,
                'name' => ($copoun && $copoun['model']) ? $copoun['model']->xcopoun_name : null,
                'code' => ($copoun && $copoun['model']) ? $copoun['model']->xcopoun_code : null,
                'discount' => $copoun ? $copoun['discount'] : 0,
            ],
            'electronic' => [
                'formula' => $extra ? $extra['formula'] : null,
                'discount' => $extra ? $extra['discount'] : 0,
            ],
            'product' => [
                'discount' => $totals['discount'] ?? 0,
            ],
            'special' => [
                'formula' => $special ? $special['formula'] : null,
                'discount' => $special ? $special['discount'] : 0,
            ],
            'accepted' => $accepted,
        ];

        return [
            'discount' => $computedDiscount,
            'discountDetail' => $discountDetail,
            'subtotal' => $totals['subtotal'],
        ];
    }

    private function getExtraDiscount($total) {
        $threshold = Config::get('cart.discount.extra.threshold', null);
        $lower = Config::get('cart.discount.extra.lower', 0);
        $upper = Config::get('cart.discount.extra.upper', 0);
        $action = Config::get('cart.discount.extra.action', 'fix');

        if (!$threshold) {
            return [
                'discount' => 0,
                'formula' => "",
            ];
        }

        $lowerDiscount = (@$action == 'percent') ? ($total * $lower) : ($lower);
        $upperDiscount = (@$action == 'percent') ? ($total * $upper) : ($upper);

        $discount = $total > $threshold ? ($upperDiscount) : ($lowerDiscount);
        return [
            'discount' => $threshold ? $discount : 0,
            'formula' => $threshold ? "{$lower}-{$threshold}-{$upper}-{$action}" : null,
        ];
    }

    private function getCopounData($total,$productsId) {
        try {
            $copounCode = $this->getCopoun();
        } catch (Exception $e) {
            return null;
        }

        $copounModel = Copoun::findByCode($copounCode);
        $copounDiscount = $copounModel ? $copounModel->limitation($total,$productsId) : 0;
        return [
            'model' => $copounModel,
            'discount' => $copounDiscount,
        ];
    }

    private function getSpecial() {
        return null;
    }
}