<?php

namespace Modules\Cart\Traits;
use Illuminate\Support\Collection;
use Modules\Cart\Exceptions\OptionException;

trait CartOptions {
    public function setCopoun($copoun) {
        return $this->setOption('copoun', $copoun);
    }

    public function removeCopoun() {
        return $this->removeOption('copoun');
    }

    public function getCopoun() {
        try {
            return $this->getOption('copoun');
        } catch (OptionException $e) {
            return null;
        }
    }

    public function verfiyCopounDiscount() {
        try {
            $productsId = [];
            foreach($this->content() as $item)
                $productsId[] = $item->id;

            $copounResult = $this->getCopounData( $this->subtotal(),$productsId);
            return $copounResult['model'] ? $copounResult['discount'] : false;

        } catch (OptionException $e) {
            return 'copoun not find';
        }

    }

    public function getCopounDiscount() {
        $discount = $this->verfiyCopounDiscount();
        return $discount ?? 0;
    }

    public function setBank($bank) {
        return $this->setOption('bank', $bank);
    }

    public function getBank() {
        try {
            return $this->getOption('bank');
        } catch (OptionException $e) {
            return 'fanava';
        }
    }

    public function setPostMethod($postMethod) {
        return $this->setOption('postMethod', $postMethod);
    }

    public function getPostMethod() {
        try {
            return $this->getOption('postMethod');
        } catch (OptionException $e) {
            return 'unknown';
        }
    }

    public function setPaymentMethod($paymentMethod) {
        return $this->setOption('paymentMethod', $paymentMethod);
    }

    public function getPaymentMethod() {
        try {
            return $this->getOption('paymentMethod');
        } catch (OptionException $e) {
            return null;
        }

    }

    public function setAddress($address) {
        return $this->setOption('address', $address);
    }

    public function getAddress() {
        try {
            return $this->getOption('address');
        } catch (OptionException $e) {
            return null;
        }
    }

    public function setOption($option, $value) {
        $content = $this->getContent();
        if (!array_key_exists('options', $content)) {
            $content['options'] = new Collection;
        }

        $content['options']->put($option, $value);

        $this->events->fire('cart.option', $value);
        $this->session->put($this->instance, $content);
        $this->session->save();
        return $value;
    }

    public function getOption($option) {
        $content = $this->getContent();
        if (!array_key_exists('options', $content)) {
            $content['options'] = new Collection;
        }

        if (!$content['options']->has($option)) {
            throw new OptionException("The cart does not contain {$option}.");
        }

        return $content['options']->get($option);
    }

    public function removeOption($option) {
        $content = $this->getContent();
        if (!array_key_exists('options', $content)) {
            $content['options'] = new Collection;
        }

        $content['options']->forget($option);

        $this->session->put($this->instance, $content);
        $this->session->save();
        return true;
    }
}