@section('content')
    <div class="col-md-12">
        <div class="table-responsive invoice-transaction">
            <table class="table table-bordered table-striped">
                @if($invoice->xinvoice_status == 'cartpayment')
                <tr>
                    <td>@t('card number'):</td>
                    <td>
                        {!! Form::text('frm[xinvoice_result]', @$invoice['xinvoice_result'], array('class' => 'form-control', ))  !!}
                    </td>
                </tr>

                <tr>
                    <td>@t('tracking code'):</td>
                    <td>
                        {!! Form::text('frm[xref_id]', @$invoice['xref_id'], array('class' => 'form-control', ))  !!}
                    </td>
                </tr>
                @elseif($invoice->xinvoice_status == 'cartpaymentAccept')
                <tr>
                    <td>@t('card number'):</td>
                    <td>
                        {{@$invoice['xinvoice_result']}}
                    </td>
                </tr>

                <tr>
                    <td>@t('tracking code'):</td>
                    <td>
                        {{@$invoice['xref_id']}}
                    </td>
                </tr>
                @elseif ($invoice->transaction)
                <tr>
                    <td>@t('bank'):</td>
                    <td>
                        {{$invoice->transaction->port}}
                    </td>
                </tr>

                <tr>
                    <td>@t('price'):</td>
                    <td>
                        {{$invoice->transaction->price}}
                    </td>
                </tr>

                <tr>
                    <td>@t('ref id'):</td>
                    <td>
                        <p style="word-break: break-word;">
                            {{$invoice->transaction->ref_id}}
                        </p>
                    </td>
                </tr>

                <tr>
                    <td>@t('tracking code'):</td>
                    <td>
                        {{$invoice->transaction->tracking_code}}
                    </td>
                </tr>

                <tr>
                    <td>@t('card number'):</td>
                    <td>
                        {{$invoice->transaction->card_number}}
                    </td>
                </tr>

                <tr>
                    <td>@t('ip'):</td>
                    <td>
                        {{$invoice->transaction->ip}}
                    </td>
                </tr>
                <tr>
                    <td>@t('date'):</td>
                    <td>
                        {{$invoice->transaction->payment_date}}
                    </td>
                </tr>
                <tr>
                    <td>@t('status'):</td>
                    <td>
                        <div class="pull-left">
                        {!! htmlStatus($invoice->transaction->status,["SUCCEED"=>"success","FAILED"=>"danger","INIT"=>"default"]) !!}
                        </div>
                    </td>
                </tr>
                @else
                    <span>تراکنش این صورت حساب یافت نشد.</span>
                    <span>و یا صورت حساب فعلی از نوع  <span style="color:red;">پرداخت در محل </span>بوده است</span>
                @endif
                <tr>
                    <td>@t('description'):</td>
                    <td>
                        {!!@$invoice['xinvoice_description']!!}
                        @if(!@$invoice['xtransaction_key'] && config('app.theme') == 'goldiran')
                        <a class="tooltips" data-url="/Admin/Invoice/resendGS/{{@$invoice['xinvoiceid']}}" title="" onclick="App.ajaxRequest(this,{overlay: {active: true}, 'resultObject': 'result-overview'});return false;" data-original-title="ارسال دوباره به GS">
                            <i class="fa fa-sync"></i>
                        </a>
                        <div class="result-overview"></div>
                        @endif
                    </td>
                </tr>
            </table>
        </div>
    </div>
<script type="text/javascript">
    $(".invoice-transaction").closest('form').find('button[type="submit"]').on('click', function() {
        if(confirm('از تائید این صورت حساب مطمئن هستید؟')) {
            return true;
        }
        return false;
    });
</script>
@stop