@section('content')
    <div class="col-12">
        <div class="table-responsive">
            <table class="table table-bordered table-striped table-hover">
                <thead>
                    <tr>
                      <th scope="col">#</th>
                      <th scope="col">نام </th>
                      <th scope="col">مبلغ واحد</th>
                      <th scope="col">تخفیف واحد</th>
                      <th scope="col"> قیمت خالص <small>واحد</small></th>
                      <th scope="col">تعداد</th>
                      <th scope="col">مبلغ کل</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach(config('app.shop') == 'product' ? $list->products : $list->books as $item)
                    <tr>
                      <th scope="row">{{$loop->iteration}}</th>
                      <td>{{config('app.shop') == 'product' ? $item->name : $item->xbook_title}}</td>
                      <td>{{FarsiLib::faNormalizeNumber($item->pivot->xinvoiceitem_price)}}</td>
                      <td>{{FarsiLib::faNormalizeNumber($item->pivot->xinvoiceitem_discount)}}</td>
                      <td>{{FarsiLib::faNormalizeNumber($item->pivot->xinvoiceitem_price - $item->pivot->xinvoiceitem_discount)}}</td>
                      <td>{{FarsiLib::faNormalizeNumber($item->pivot->xinvoiceitem_quantity)}}</td>
                      <td>{{FarsiLib::faNormalizeNumber(((int)$item->pivot->xinvoiceitem_price - (int)$item->pivot->xinvoiceitem_discount) * (int)$item->pivot->xinvoiceitem_quantity)}}</td>
                    </tr>
                    @endforeach

                    <tr>
                        <td colspan="4"></td>

                        <td class="bold"> جمع مبالغ ناخالص :</td>
                        <td class="bold" colspan="2">{{FarsiLib::faNormalizeNumber($list->xinvoice_subtotal)}} تومان</td>
                    </tr>
                    <tr>
                        <td colspan="4"></td>

                        <td class="bold">مجموع تخفیفات:</td>
                        <td class="bold" colspan="2">{{FarsiLib::faNormalizeNumber($list->xinvoice_discount)}} تومان</td>
                    </tr>
                    <tr>
                        <td colspan="4"></td>

                        <td class="bold">هزینه ارسال {{t($list->xinvoice_ship)}}:</td>
                        <td class="bold" colspan="2">{{FarsiLib::faNormalizeNumber($list->xinvoice_ship_price)}} تومان</td>
                    </tr>
                    <tr>
                        <td colspan="4"></td>

                        <td class="bold"> مبلغ  کد تخفیف {{$list->xinvoice_copoun_code}}:</td>
                        <td class="bold" colspan="2">{{FarsiLib::faNormalizeNumber($list->xinvoice_copoun_discount)}} تومان</td>
                    </tr>
                    <tr>
                        <td colspan="4"></td>

                        <td class="bold"> جمع فاکتور: </td>
                        <td class="bold" colspan="2">{{FarsiLib::faNormalizeNumber($list->xinvoice_total)}} تومان</td>
                    </tr>
                  </tbody>
            </table>
        </div>
    </div>
@stop