<?php

namespace Modules\Cart\Providers;

use Illuminate\Auth\Events\Logout;
use Illuminate\Database\Eloquent\Factory;
use Illuminate\Session\SessionManager;
use Illuminate\Support\ServiceProvider;
use Modules\Cart\Entities\Cart;

class CartServiceProvider extends ServiceProvider {
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Boot the application events.
     *
     * @return void
     */
    public function boot() {
        $this->registerTranslations();
        $this->registerConfig();
        $this->registerViews();
        $this->registerFactories();
        $this->loadMigrationsFrom(__DIR__ . '/../Database/Migrations');

        $this->app['events']->listen(Logout::class, function () {
            if ($this->app['config']->get('cart.destroy_on_logout')) {
                $this->app->make(SessionManager::class)->forget('cart');
            }
        });
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register() {

    }

    /**
     * Register config.
     *
     * @return void
     */
    protected function registerConfig() {
        $this->publishes([
            __DIR__ . '/../Config/config.php' => config_path('cart.php'),
        ], 'config');
        $this->mergeConfigFrom(
            __DIR__ . '/../Config/config.php', 'cart'
        );

        if (file_exists(__DIR__ . '/../Config/route.php')) {
            $this->mergeConfigFrom(
                __DIR__ . '/../Config/route.php', 'route'
            );
        }
    }

    /**
     * Register views.
     *
     * @return void
     */
    public function registerViews() {
        $viewPath = resource_path('views/modules/cart');

        $sourcePath = __DIR__ . '/../Resources/views';

        $theme = config('app.theme','cppc');
        $newSourcePath = resource_path("views/index/{$theme}/modules/cart/views");

        $this->publishes([
            $sourcePath => $viewPath,
        ], 'views');

        $this->loadViewsFrom(array_merge(array_map(function ($path) {
            return $path . '/modules/cart';
        }, \Config::get('view.paths')), [$sourcePath, $newSourcePath]), 'cart');
    }

    /**
     * Register translations.
     *
     * @return void
     */
    public function registerTranslations() {
        $langPath = resource_path('lang/modules/cart');

        if (is_dir($langPath)) {
            $this->loadTranslationsFrom($langPath, 'cart');
        } else {
            $this->loadTranslationsFrom(__DIR__ . '/../Resources/lang', 'cart');
        }
    }

    /**
     * Register an additional directory of factories.
     *
     * @return void
     */
    public function registerFactories() {
        if (!app()->environment('production')) {
            app(Factory::class)->load(__DIR__ . '/../Database/factories');
        }
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides() {
        return [];
    }
}
