<?php namespace Modules\Cart\Models;

use App\Models\Model;
use DB;
use Modules\Account\Models\User;

class Transaction extends Model {
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'xxshop_gateway_transactions';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;
    public $lang = false;

    protected $guarded = [];

    /**
     * Get the user for the invoice.
     */
    public function invoice() {
        return $this->belongsTo(Invoice::class, 'invoiceid');
    }

    /**
     * Get the province for the invoice.
     */
    public function log() {
        return $this->hasMany(Transaction::class, 'transaction_id');
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        $res = DB::table("$instance->table")
            ->orderBy('updated_at', 'DESC')
            ->orderBy('status', 'DESC')
            ->select(['*', "{$instance->primaryKey} AS xid"]);

        return $res;
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();

        if ($id) {
            $res = $instance->destroy($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }

        return $res;
    }
}