<?php namespace Modules\Cart\Models;

use App\Models\Model;
use DB;
use Modules\Cart\Models\Invoice;

class Returned extends Model {
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'shop_order_returned';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;
    public $lang = false;

    protected $guarded = ['id'];

    protected $casts = [
        'invoice_id' => 'int',
        'product_id' => 'int',
        'reason' => 'int',
        'status' => 'int',
    ];

    public static $reasons = [
        1 =>'کالا ایراد فنی دارد',
        2 =>'کالا دارای خط و خش ظاهری می باشد',
        3 =>'کالا مطابق با سفارش ثبت شده نمی باشد',
        4 =>'از خرید منصرف شدم',
        5 =>'کالا را اشتباه سفارش دادم',
        6 =>'قطعه با دستگاه مطابقت ندارد'
    ];

    /**
     * Get the book for the cart.
     */
    public function invoice() {
        return $this->blongsTo(Invoice::class, 'invoice_id');
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        $res = DB::table("$instance->table")
            ->leftJoin('shop_product as sp','sp.id','=','product_id')
            ->leftJoin('xxshop_invoice as i','i.xinvoiceid','=','invoice_id')
            ->leftJoin(DB::raw("(".self::arrayToSqlTable(self::$reasons).") as r"),'r.id','=','reason')
            ->select(['sp.*','i.*','r.name as reason_name',"{$instance->table}.*", "{$instance->table}.{$instance->primaryKey} AS xid"]);

        return $res;
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();

        if ($id) {
            $res = $instance->destroy($id);
            parent::deleteFile($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }

        return $res;
    }
}