<?php namespace Modules\Cart\Models;

use App\Models\Model;
use DB;
use Modules\Cart\Models\Invoice;

class InvoiceItem extends Model {
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'xxshop_invoiceitem';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'xinvoiceitemid';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;
    public $lang = false;

    protected $guarded = ['xinvoiceitemid'];

    protected $casts = [
        'xinvoiceid' => 'int',
        'xbookid' => 'int',
        'xpackageid' => 'int',
        'xinvoiceitem_price' => 'int',
        'xinvoiceitem_quantity' => 'int',
    ];

    /**
     * Get the book for the cart.
     */
    public function invoice() {
        return $this->blongsTo(Invoice::class, 'xinvoiceid');
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        $res = DB::table("$instance->table")
            ->select(['*', "{$instance->primaryKey} AS xid"]);

        return $res;
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();

        if ($id) {
            $res = $instance->destroy($id);
            parent::deleteFile($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }

        return $res;
    }
}