<?php namespace Modules\Cart\Models;

use App\Models\Model;
use DB;
use Modules\Account\Models\User;
use Modules\Book\Models\Book;
use Modules\Cart\Models\Transaction;
use Modules\Home\Models\Province;
use Modules\Shop\Models\Product;
use Modules\Account\Models\UserInfo;
use Modules\Home\Models\County;

class Invoice extends Model {
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'xxshop_invoice';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'xinvoiceid';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;
    public $lang = false;

    protected $hidden = array('pivot');

    protected $guarded = ['xinvoiceid'];

    protected $casts = [
        'xuserid' => 'int',
        'xinvoice_number' => 'int',
        'xinvoice_code' => 'int',
        'xinvoice_date' => 'dateTime',
        'xinvoice_discount' => 'int',
        'xinvoice_total' => 'int',
        'xinvoice_subtotal' => 'int',
        'xprovienceid' => 'int',
        'xinvoice_tax' => 'int',
        'xinvoice_shipped' => 'bool',
    ];

    /**
     * Get the user for the invoice.
     */
    public function user() {
        return $this->belongsTo(UserInfo::class, 'xuserid');
    }

    /**
     * Get the province for the invoice.
     */
    public function province() {
        return $this->belongsTo(Province::class, 'xprovinceid');
    }

    public function county() {
        return $this->belongsTo(County::class, 'xcityid');
    }

    /**
     * Get the phone record associated with the user.
     */
    public function transaction() {
        return $this->hasOne(Transaction::class, 'invoiceid');
    }

    /**
     * Get the books for the invoice.
     */
    public function books() {
        return $this->belongsToMany(Book::class, 'xxshop_invoiceitem', 'xinvoiceid', 'xbookid')->withPivot('xinvoiceitem_price', 'xinvoiceitem_discount', 'xinvoiceitem_quantity');
    }

     /**
     * Get the books for the invoice.
     */
    public function products() {
        return $this->belongsToMany(Product::class, 'xxshop_invoiceitem', 'xinvoiceid', 'xbookid')->withPivot('xinvoiceitem_price', 'xinvoiceitem_discount', 'xinvoiceitem_quantity');
    }

    public function items() {
        return $this->hasMany(InvoiceItem::class, 'xinvoiceid');
    }

    public function returned() {
        return $this->hasMany(Returned::class, 'invoice_id');
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        $res = DB::table("$instance->table AS i")
            ->leftJoin(DB::raw('(select xuserid,xname,xfamily from xxsecurity_userinfo) as ui'), 'ui.xuserid', '=', 'i.xuserid')
            ->leftJoin(DB::raw('(select xuserid,xusername from xxsecurity_user) as u'), 'u.xuserid', '=', 'i.xuserid')
            //->leftJoin('xxshop_gateway_transactions as t', 't.invoiceid', '=', 'i.xinvoiceid')
            ->where('i.type',1)
            ->orderBy('i.xinvoice_date', 'DESC')
            ->select(['*', "{$instance->primaryKey} AS xid"]);

        return $res;
    }

    public static function getOverItemsInvoice() {
        $instance = new static();

        $res = DB::table("$instance->table AS i")
            ->leftJoin('xxshop_invoiceitem as ii', 'ii.xinvoiceid', '=', 'i.xinvoiceid')
            ->leftJoin('xxbook as b', 'ii.xbookid', '=', 'b.xbookid')
            ->orderBy('i.xinvoice_date', 'DESC')
            ->select(['*', "{$instance->primaryKey} AS xid"]);

        return $res;
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();

        if ($id) {
            $res = $instance->destroy($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }

        return $res;
    }
}