<?php namespace Modules\Cart\Models;

use App\Models\Model;
use DB;
use Auth;
use Illuminate\Support\Carbon;
use Modules\Account\Models\User;
use Modules\Book\Models\SubCategory;
use Modules\Shop\Models\Group;
use Modules\Shop\Models\Product;

class Copoun extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'xxshop_copoun';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'xcopounid';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;
    public $lang = false;

    protected $guarded = ['xcopounid'];

    protected $casts = [
        'xsubcategoryid' => 'int',
        'xcopoun_discount' => 'int',
        'xcopoun_max_discount' => 'int',
        'xcopoun_expires_at' => 'j2timestamp',
        'xrank' => 'int',
    ];

    /**
     * Get the user for the invoice.
     */
    public function user() {
        return $this->belongsToMany(User::class, 'xxshop_copoun_user', 'xcopounid', 'xuserid');
    }

    /**
     * Get the book for the cart.
     */
    public function category()
    {
        if (config('app.shop') == 'product')
            return $this->belongsTo(Group::class, 'xsubcategoryid');
        else
            return $this->belongsTo(SubCategory::class, 'xsubcategoryid');
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult()
    {
        $instance = new static();

        $res = DB::table("$instance->table")
            ->select(['*', "{$instance->primaryKey} AS xid"]);

        return $res;
    }

    public static function updateById($data, $id = 0)
    {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id)
    {
        $instance = new static();

        if ($id) {
            $res = $instance->destroy($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }

        return $res;
    }

    public static function findByCode($code)
    {
        $instance = new static();
        return $instance->where('xcopoun_code', $code)->first();
    }

    public function discountPrice($total)
    {
        if ($this->xcopoun_type == 'flat') {
            return $this->xcopoun_discount;
        } elseif ($this->xcopoun_type == 'percent') {
            return round(((int)$this->xcopoun_discount / 100) * $total);
        } else {
            return 0;
        }
    }

    public function limitation($total, $products)
    {
        if ($this->xcopoun_expires_at < Carbon::now()) {
            return false;
        }
        if ($this->xcopoun_status != 1) {
            return false;
        }
        if ($this->xcopoun_used_count < 1) {
            return false;
        }
        if ($this->xcopoun_min_buy > $total){
            return false;
        }
        if($this->xcopoun_first_order){
            $user = Auth::user();
            if($user->invoices()->where('xinvoice_status','onlinepaymentfinal')->count() > 0){
                return false;
            }
        }
        if($this->user->count()){
            $user = Auth::user();
            if(!$this->user->contains('xuserid',$user->xuserid)){
                return false;
            }
        }
        
        if ($this->xcopoun_categoryid){
            if (config('app.shop') == 'product'){
                $categories = Product::whereIn('id',$products)->select('group_id')->distinct()->get();
                foreach ($categories as $cat) {
                    if ($this->xcopoun_categoryid != $cat->group_id)
                        return false;
                }
            }
            else{
                $categories = Book::whereIn('xbookid',$products)->select('xsubcategoryid')->distinct()->get();
                foreach ($categories as $cat) {
                    if ($this->xcopoun_categoryid != $cat->xsubcategoryid)
                        return false;
                }
            }
        }

        if($this->xcopoun_productids){
            $copounProducts = json_decode($this->xcopoun_productids,true);
            if($copounProducts && $products){
                $notIntersect = empty(array_intersect($copounProducts, $products));
                if($notIntersect) return false;
            }
        }
        
        $discount = $this->discountPrice($total);

        if ($this->xcopoun_max_discount < $discount) {
            return $this->xcopoun_max_discount;
        }

        return $discount;
    }
}
